
(require 'gtk-helper-syntax) ;; provides syntax used below!

(define-syntax define-gtk-enum
  (syntax-rules ()
    ((_ enum-type (decls ...) (scm-name c-name) ...)
     (invoke-form/target-dep-paths
      define-gtk-enum/swap-in-paths 
      enum-type (decls ...)
      (scm-name c-name) ...))))

(define-syntax define-gtk-enum/swap-in-paths
  (syntax-rules ()
    ((_ (PATHS ...) enum-type (decls ...) . ARGS)
     (define-c-enum enum-type ((path PATHS) ... decls ...) . ARGS))))

(define-syntax define-gtk-enum-set
  (syntax-rules ()
    ((_ enum-type (decls ...) (scm-name c-name) ...)
     (invoke-form/target-dep-paths
      define-gtk-enum-set/swap-in-paths 
      enum-type (decls ...)
      (scm-name c-name) ...))))

(define-syntax define-gtk-enum-set/swap-in-paths
  (syntax-rules ()
    ((_ (PATHS ...) enum-type (decls ...) . ARGS)
     (define-c-enum-set enum-type ((path PATHS) ... decls ...) . ARGS))))

(define-gtk-enum gtkanchortype ((include<> "gtk/gtkenums.h"))
  (center "GTK_ANCHOR_CENTER")
  (north "GTK_ANCHOR_NORTH")
  (north-west "GTK_ANCHOR_NORTH_WEST")
  (north-east "GTK_ANCHOR_NORTH_EAST")
  (south "GTK_ANCHOR_SOUTH")
  (south-west "GTK_ANCHOR_SOUTH_WEST")
  (south-east "GTK_ANCHOR_SOUTH_EAST")
  (west "GTK_ANCHOR_WEST")
  (east "GTK_ANCHOR_EAST")
  (n "GTK_ANCHOR_N")
  (nw "GTK_ANCHOR_NW")
  (ne "GTK_ANCHOR_NE")
  (s "GTK_ANCHOR_S")
  (sw "GTK_ANCHOR_SW")
  (se "GTK_ANCHOR_SE")
  (w "GTK_ANCHOR_W")
  (e "GTK_ANCHOR_E"))

(define-gtk-enum gtkarrowtype ((include<> "gtk/gtkenums.h"))
  (up    "GTK_ARROW_UP")
  (down  "GTK_ARROW_DOWN")
  (left  "GTK_ARROW_LEFT")
  (right "GTK_ARROW_RIGHT"))

(define-gtk-enum-set gtkattachoptions ((include<> "gtk/gtkenums.h"))
  (expand "GTK_EXPAND")
  (shrink "GTK_SHRINK")
  (fill "GTK_FILL"))

(define-gtk-enum gtkbuttonboxstyle ((include<> "gtk/gtkenums.h"))
  (default-style "GTK_BUTTONBOX_DEFAULT_STYLE")
  (spread "GTK_BUTTONBOX_SPREAD")
  (edge "GTK_BUTTONBOX_EDGE")
  (start "GTK_BUTTONBOX_START")
  (end "GTK_BUTTONBOX_END"))

(define-gtk-enum gtkcurvetype ((include<> "gtk/gtkenums.h"))
  (linear "GTK_CURVE_TYPE_LINEAR")
  (spline "GTK_CURVE_TYPE_SPLINE")
  (free   "GTK_CURVE_TYPE_FREE"))

(define-gtk-enum gtkdeletetype ((include<> "gtk/gtkenums.h"))
  (chars             "GTK_DELETE_CHARS")
  (word-ends         "GTK_DELETE_WORD_ENDS")
  (words             "GTK_DELETE_WORDS")
  (display-lines     "GTK_DELETE_DISPLAY_LINES")
  (display-line-ends "GTK_DELETE_DISPLAY_LINE_ENDS")
  (paragraph-ends    "GTK_DELETE_PARAGRAPH_ENDS")
  (paragraphs        "GTK_DELETE_PARAGRAPHS")
  (whitespace        "GTK_DELETE_WHITESPACE"))

(define-gtk-enum gtkdirectiontype ((include<> "gtk/gtkenums.h"))
  (forward  "GTK_DIR_TAB_FORWARD")
  (backward "GTK_DIR_TAB_BACKWARD")
  (up       "GTK_DIR_UP")
  (down     "GTK_DIR_DOWN")
  (left     "GTK_DIR_LEFT")
  (right    "GTK_DIR_RIGHT"))

(define-gtk-enum gtkexpanderstyle ((include<> "gtk/gtkenums.h"))
  (collapsed      "GTK_EXPANDER_COLLAPSED")
  (semi-collapsed "GTK_EXPANDER_SEMI_COLLAPSED")
  (semi-expanded  "GTK_EXPANDER_SEMI_EXPANDED")
  (expanded       "GTK_EXPANDER_EXPANDED"))

(define-gtk-enum gtkiconsize ((include<> "gtk/gtkenums.h"))
  (invalid       "GTK_ICON_SIZE_INVALID")
  (menu          "GTK_ICON_SIZE_MENU")
  (small-toolbar "GTK_ICON_SIZE_SMALL_TOOLBAR")
  (large-toolbar "GTK_ICON_SIZE_LARGE_TOOLBAR")
  (button        "GTK_ICON_SIZE_BUTTON")
  (dnd           "GTK_ICON_SIZE_DND")
  (dialog        "GTK_ICON_SIZE_DIALOG"))

(define-gtk-enum gtktextdirection ((include<> "gtk/gtkenums.h"))
  (none "GTK_TEXT_DIR_NONE")
  (ltr  "GTK_TEXT_DIR_LTR")
  (rtl  "GTK_TEXT_DIR_RTL"))

(define-gtk-enum gtkjustification ((include<> "gtk/gtkenums.h"))
  (left "GTK_JUSTIFY_LEFT")
  (right "GTK_JUSTIFY_RIGHT")
  (center "GTK_JUSTIFY_CENTER")
  (fill "GTK_JUSTIFY_FILL"))

(define-gtk-enum gtkmenudirectiontype ((include<> "gtk/gtkenums.h"))
  (parent "GTK_MENU_DIR_PARENT")
  (child "GTK_MENU_DIR_CHILD")
  (next "GTK_MENU_DIR_NEXT")
  (prev "GTK_MENU_DIR_PREV"))

(define-gtk-enum gtkmetrictype ((include<> "gtk/gtkenums.h"))
  (pixels "GTK_PIXELS")
  (inches "GTK_INCHES")
  (centimeters "GTK_CENTIMETERS"))

(define-gtk-enum gtkmovementstep ((include<> "gtk/gtkenums.h"))
  (logical-positions  "GTK_MOVEMENT_LOGICAL_POSITIONS")
  (visual-positions   "GTK_MOVEMENT_VISUAL_POSITIONS")
  (words              "GTK_MOVEMENT_WORDS")
  (display-lines      "GTK_MOVEMENT_DISPLAY_LINES")
  (display-lines-ends "GTK_MOVEMENT_DISPLAY_LINE_ENDS")
  (paragraphs         "GTK_MOVEMENT_PARAGRAPHS")
  (paragraphs-ends    "GTK_MOVEMENT_PARAGRAPH_ENDS")
  (pages              "GTK_MOVEMENT_PAGES")
  (buffer-ends        "GTK_MOVEMENT_BUFFER_ENDS")
  (horizontal-pages   "GTK_MOVEMENT_HORIZONTAL_PAGES"))

(define-gtk-enum gtkscrollstep ((include<> "gtk/gtkenums.h"))
  (steps "GTK_SCROLL_STEPS")
  (pages "GTK_SCROLL_PAGES")
  (ends  "GTK_SCROLL_ENDS")
  (horizontal-steps "GTK_SCROLL_HORIZONTAL_STEPS")
  (horizontal-pages "GTK_SCROLL_HORIZONTAL_PAGES")
  (horizontal-ends  "GTK_SCROLL_HORIZONTAL_ENDS"))

(define-gtk-enum gtkorientation  ((include<> "gtk/gtkenums.h"))
  (horizontal "GTK_ORIENTATION_HORIZONTAL")
  (vertical "GTK_ORIENTATION_VERTICAL"))

(define-gtk-enum gtkcornertype ((include<> "gtk/gtkenums.h"))
  (top-left     "GTK_CORNER_TOP_LEFT")
  (bottom-left  "GTK_CORNER_BOTTOM_LEFT")
  (top-right    "GTK_CORNER_TOP_RIGHT")
  (bottom-right "GTK_CORNER_BOTTOM_RIGHT"))

(define-gtk-enum gtkpacktype ((include<> "gtk/gtkenums.h"))
  (start "GTK_PACK_START")
  (end   "GTK_PACK_END"))

(define-gtk-enum gtkpathprioritytype ((include<> "gtk/gtkenums.h"))
  (lowest      "GTK_PATH_PRIO_LOWEST")
  (gtk         "GTK_PATH_PRIO_GTK")
  (application "GTK_PATH_PRIO_APPLICATION")
  (theme       "GTK_PATH_PRIO_THEME")
  (rc          "GTK_PATH_PRIO_RC")
  (highest     "GTK_PATH_PRIO_HIGHEST"))

(define-gtk-enum gtkpathtype ((include<> "gtk/gtkenums.h"))
  (widget "GTK_PATH_WIDGET")
  (widget-class "GTK_PATH_WIDGET_CLASS")
  (path-class "GTK_PATH_CLASS"))

(define-gtk-enum gtkpolicytype ((include<> "gtk/gtkenums.h"))
  (always "GTK_POLICY_ALWAYS")
  (automatic "GTK_POLICY_AUTOMATIC")
  (never "GTK_POLICY_NEVER"))

(define-gtk-enum gtkpositiontype ((include<> "gtk/gtkenums.h"))
  (left   "GTK_POS_LEFT")
  (right  "GTK_POS_RIGHT")
  (top    "GTK_POS_TOP")
  (bottom "GTK_POS_BOTTOM"))

(define-gtk-enum gtkpreviewtype ((include<> "gtk/gtkenums.h"))
  (color     "GTK_PREVIEW_COLOR")
  (grayscale "GTK_PREVIEW_GRAYSCALE"))

(define-gtk-enum gtkreliefstyle ((include<> "gtk/gtkenums.h"))
  (normal "GTK_RELIEF_NORMAL")
  (half   "GTK_RELIEF_HALF")
  (none   "GTK_RELIEF_NONE"))

(define-gtk-enum gtkresizemode ((include<> "gtk/gtkenums.h"))
  (parent    "GTK_RESIZE_PARENT")
  (queue     "GTK_RESIZE_QUEUE")
  (immediate "GTK_RESIZE_IMMEDIATE"))

(define-gtk-enum gtkscrolltype ((include<> "gtk/gtkenums.h"))
  (none          "GTK_SCROLL_NONE")
  (jump          "GTK_SCROLL_JUMP")
  (step-backward "GTK_SCROLL_STEP_BACKWARD")
  (step-forward  "GTK_SCROLL_STEP_FORWARD")
  (page-backward "GTK_SCROLL_PAGE_BACKWARD")
  (page-forward  "GTK_SCROLL_PAGE_FORWARD")
  (step-up       "GTK_SCROLL_STEP_UP")
  (step-down     "GTK_SCROLL_STEP_DOWN")
  (page-up       "GTK_SCROLL_PAGE_UP")
  (page-down     "GTK_SCROLL_PAGE_DOWN")
  (step-left     "GTK_SCROLL_STEP_LEFT")
  (step-right    "GTK_SCROLL_STEP_RIGHT")
  (page-left     "GTK_SCROLL_PAGE_LEFT")
  (page-right    "GTK_SCROLL_PAGE_RIGHT")
  (start         "GTK_SCROLL_START")
  (end           "GTK_SCROLL_END"))

(define-gtk-enum gtkselectionmode ((include<> "gtk/gtkenums.h"))
  (none   "GTK_SELECTION_NONE")
  (single "GTK_SELECTION_SINGLE")
  (browse "GTK_SELECTION_BROWSE")
  (multiple "GTK_SELECTION_MULTIPLE"))

(define-gtk-enum gtkshadowtype ((include<> "gtk/gtkenums.h"))
  (none   "GTK_SHADOW_NONE")
  (in     "GTK_SHADOW_IN")
  (out    "GTK_SHADOW_OUT")
  (etched-in "GTK_SHADOW_ETCHED_IN")
  (etched-out "GTK_SHADOW_ETCHED_OUT"))

(define-gtk-enum gtkstatetype ((include<> "gtk/gtkenums.h"))
  (normal   "GTK_STATE_NORMAL")
  (active   "GTK_STATE_ACTIVE")
  (prelight "GTK_STATE_PRELIGHT")
  (selected "GTK_STATE_SELECTED")
  (insensitive "GTK_STATE_INSENSITIVE"))

(define-gtk-enum gtktoolbarstyle ((include<> "gtk/gtkenums.h"))
  (icons  "GTK_TOOLBAR_ICONS")
  (text   "GTK_TOOLBAR_TEXT")
  (both   "GTK_TOOLBAR_BOTH")
  (both-horiz "GTK_TOOLBAR_BOTH_HORIZ"))

(define-gtk-enum gtkupdatetype ((include<> "gtk/gtkenums.h"))
  (continuous    "GTK_UPDATE_CONTINUOUS")
  (discontinuous "GTK_UPDATE_DISCONTINUOUS")
  (delayed       "GTK_UPDATE_DELAYED"))

(define-gtk-enum gtkvisibility ((include<> "gtk/gtkenums.h"))
  (none    "GTK_VISIBILITY_NONE")
  (partial "GTK_VISIBILITY_PARTIAL")
  (full    "GTK_VISIBILITY_FULL"))

(define-gtk-enum gtkwindowposition ((include<> "gtk/gtkenums.h"))
  (none             "GTK_WIN_POS_NONE")
  (center           "GTK_WIN_POS_CENTER")
  (mouse            "GTK_WIN_POS_MOUSE")
  (center-always    "GTK_WIN_POS_CENTER_ALWAYS")
  (center-on-parent "GTK_WIN_POS_CENTER_ON_PARENT"))

(define-gtk-enum gtkwindowtype ((include<> "gtk/gtkenums.h"))
  (toplevel "GTK_WINDOW_TOPLEVEL")
  (popup    "GTK_WINDOW_POPUP"))

(define-gtk-enum gtkwrapmode ((include<> "gtk/gtkenums.h"))
  (none      "GTK_WRAP_NONE")
  (char      "GTK_WRAP_CHAR")
  (word      "GTK_WRAP_WORD")
  (word-char "GTK_WRAP_WORD_CHAR"))

(define-gtk-enum gtksorttype ((include<> "gtk/gtkenums.h"))
  (ascending  "GTK_SORT_ASCENDING")
  (descending "GTK_SORT_DESCENDING"))

(define-gtk-enum gtkimpreeditstyle ((include<> "gtk/gtkenums.h"))
  (nothing  "GTK_IM_PREEDIT_NOTHING")
  (callback "GTK_IM_PREEDIT_CALLBACK")
  (none     "GTK_IM_PREEDIT_NONE"))
 
(define-gtk-enum gtkimstatusstyle ((include<> "gtk/gtkenums.h"))
  (nothing  "GTK_IM_STATUS_NOTHING")
  (callback "GTK_IM_STATUS_CALLBACK")
  (none     "GTK_IM_STATUS_NONE"))

(define-gtk-enum-set gtkdialogflags ((include<> "gtk/gtkdialog.h")) 
  (modal               "GTK_DIALOG_MODAL")
  (destroy-with-parent "GTK_DIALOG_DESTROY_WITH_PARENT")
  (no-separator        "GTK_DIALOG_NO_SEPARATOR"))

(define-gtk-enum gtkresponsetype ((include<> "gtk/gtkdialog.h")) 
  (none   "GTK_RESPONSE_NONE")
  (reject "GTK_RESPONSE_REJECT")
  (accept "GTK_RESPONSE_ACCEPT")
  (ok     "GTK_RESPONSE_OK")
  (cancel "GTK_RESPONSE_CANCEL")
  (close  "GTK_RESPONSE_CLOSE")
  (yes    "GTK_RESPONSE_YES")
  (no     "GTK_RESPONSE_NO")
  (apply  "GTK_RESPONSE_APPLY")
  (help   "GTK_RESPONSE_HELP"))

(define-gtk-enum gtkmessagetype ((include<> "gtk/gtkmessagedialog.h"))
  (info     "GTK_MESSAGE_INFO")
  (warning  "GTK_MESSAGE_WARNING")
  (question "GTK_MESSAGE_QUESTION")
  (error    "GTK_MESSAGE_ERROR"))

(define-gtk-enum gtkbuttonstype ((include<> "gtk/gtkmessagedialog.h"))
  (none      "GTK_BUTTONS_NONE")
  (ok        "GTK_BUTTONS_OK")
  (close     "GTK_BUTTONS_CLOSE")
  (cancel    "GTK_BUTTONS_CANCEL")
  (yes/no    "GTK_BUTTONS_YES_NO")
  (ok/cancel "GTK_BUTTONS_OK_CANCEL"))

(define-gtk-enum-set gdkwindowhints ((include<> "gdk/gdkwindow.h"))
  (pos "GDK_HINT_POS")
  (min-size "GDK_HINT_MIN_SIZE")
  (max-size "GDK_HINT_MAX_SIZE")
  (base-size "GDK_HINT_BASE_SIZE")
  (aspect "GDK_HINT_ASPECT")
  (resize-increment "GDK_HINT_RESIZE_INC")
  (window-gravity "GDK_HINT_WIN_GRAVITY")
  (user-pos "GDK_HINT_USER_POS")
  (user-size "GDK_HINT_USER_SIZE"))

(define-gtk-enum gdkgravity ((include<> "gdk/gdkwindow.h"))
  (north-west "GDK_GRAVITY_NORTH_WEST")
  (north      "GDK_GRAVITY_NORTH")
  (north-east "GDK_GRAVITY_NORTH_EAST")
  (west       "GDK_GRAVITY_WEST")
  (center     "GDK_GRAVITY_CENTER")
  (east       "GDK_GRAVITY_EAST")
  (south-west "GDK_GRAVITY_SOUTH_WEST")
  (south      "GDK_GRAVITY_SOUTH")
  (south-east "GDK_GRAVITY_SOUTH_EAST")
  (static     "GDK_GRAVITY_STATIC"))

(define-gtk-enum-set gdkmodifiertype ((include "gdk/gdktypes.h"))
  (shift    "GDK_SHIFT_MASK")
  (lock     "GDK_LOCK_MASK")
  (control  "GDK_CONTROL_MASK")
  (mod1     "GDK_MOD1_MASK")
  (mod2     "GDK_MOD2_MASK")
  (mod3     "GDK_MOD3_MASK")
  (mod4     "GDK_MOD4_MASK")
  (mod5     "GDK_MOD5_MASK")
  (button1  "GDK_BUTTON1_MASK")
  (button2  "GDK_BUTTON2_MASK")
  (button3  "GDK_BUTTON3_MASK")
  (button4  "GDK_BUTTON4_MASK")
  (button5  "GDK_BUTTON5_MASK")
  (release  "GDK_RELEASE_MASK")
  (modifier "GDK_MODIFIER_MASK"))

(define-gtk-enum gdkwindowedge ((include<> "gdk/gdkwindow.h"))
  (north-west "GDK_WINDOW_EDGE_NORTH_WEST")
  (north      "GDK_WINDOW_EDGE_NORTH")
  (north-east "GDK_WINDOW_EDGE_NORTH_EAST")
  (west       "GDK_WINDOW_EDGE_WEST")
  (east       "GDK_WINDOW_EDGE_EAST")
  (south-west "GDK_WINDOW_EDGE_SOUTH_WEST")
  (south      "GDK_WINDOW_EDGE_SOUTH")
  (south-east "GDK_WINDOW_EDGE_SOUTH_EAST"))

(define-gtk-enum gdkwindowtypehint ((include<> "gdk/gdkwindow.h"))
  (normal       "GDK_WINDOW_TYPE_HINT_NORMAL")
  (dialog       "GDK_WINDOW_TYPE_HINT_DIALOG")
  (menu         "GDK_WINDOW_TYPE_HINT_MENU")
  (toolbar      "GDK_WINDOW_TYPE_HINT_TOOLBAR")
  (splashscreen "GDK_WINDOW_TYPE_HINT_SPLASHSCREEN")
  (utility      "GDK_WINDOW_TYPE_HINT_UTILITY")
  (dock         "GDK_WINDOW_TYPE_HINT_DOCK")
  (desktop      "GDK_WINDOW_TYPE_HINT_DESKTOP"))

(define-gtk-enum gtkprogressbarstyle ((include<> "gtk/gtkprogressbar.h"))
  (continuous   "GTK_PROGRESS_CONTINUOUS")
  (discrete     "GTK_PROGRESS_DISCRETE"))

(define-gtk-enum gtkprogressbarorientation ((include<> "gtk/gtkprogressbar.h"))
  (left-to-right "GTK_PROGRESS_LEFT_TO_RIGHT")
  (right-to-left "GTK_PROGRESS_RIGHT_TO_LEFT")
  (bottom-to-top "GTK_PROGRESS_BOTTOM_TO_TOP")
  (top-to-bottom "GTK_PROGRESS_TOP_TO_BOTTOM"))

(define-gtk-enum-set gtkaccelgroup ((include<> "gtk/gtkaccelgroup.h"))
  (visible "GTK_ACCEL_VISIBLE")
  (locked "GTK_ACCEL_LOCKED")
  (mask "GTK_ACCEL_MASK"))

(define-gtk-enum-set gtkwidgetflags ((include<> "gtk/gtkwidget.h"))
  (toplevel "GTK_TOPLEVEL")
  (no-window "GTK_NO_WINDOW")
  (realized "GTK_REALIZED")
  (mapped "GTK_MAPPED")
  (visible "GTK_VISIBLE")
  (sensitive "GTK_SENSITIVE")
  (parent-sensitive "GTK_PARENT_SENSITIVE")
  (can-focus "GTK_CAN_FOCUS")
  (has-focus "GTK_HAS_FOCUS")
  (can-default "GTK_CAN_DEFAULT")
  (has-default "GTK_HAS_DEFAULT")
  (has-grab "GTK_HAS_GRAB")
  (rc-style "GTK_RC_STYLE")
  (composite-child "GTK_COMPOSITE_CHILD")
  (no-reparent "GTK_NO_REPARENT")
  (app-paintable "GTK_APP_PAINTABLE")
  (receives-default "GTK_RECEIVES_DEFAULT")
  (double-buffered "GTK_DOUBLE_BUFFERED")
  (no-show-all "GTK_NO_SHOW_ALL"))

(define-gtk-enum gtkwidgethelptype ((include<> "gtk/gtkwidget.h"))
  (tooltip "GTK_WIDGET_HELP_TOOLTIP")
  (whats-this "GTK_WIDGET_HELP_WHATS_THIS"))

(define-gtk-enum gtktextwindowtype ((include<> "gtk/gtktextview.h"))
  (private "GTK_TEXT_WINDOW_PRIVATE")
  (widget "GTK_TEXT_WINDOW_WIDGET")
  (text "GTK_TEXT_WINDOW_TEXT")
  (left "GTK_TEXT_WINDOW_LEFT")
  (right "GTK_TEXT_WINDOW_RIGHT")
  (top "GTK_TEXT_WINDOW_TOP")
  (bottom "GTK_TEXT_WINDOW_BOTTOM"))

(define-gtk-enum gtkimagetype ((include<> "gtk/gtkimage.h"))
  (empty "GTK_IMAGE_EMPTY")
  (pixmap "GTK_IMAGE_PIXMAP")
  (image  "GTK_IMAGE_IMAGE")
  (pixbuf "GTK_IMAGE_PIXBUF")
  (stock  "GTK_IMAGE_STOCK")
  (icon-set "GTK_IMAGE_ICON_SET")
  (animation "GTK_IMAGE_ANIMATION")
  (icon-name "GTK_IMAGE_ICON_NAME"))
