(require 'std-ffi)
(require 'foreign-ctools)
(require 'foreign-cenums)

(define-syntax define-gl-enum 
  (syntax-rules ()
    ((_ gl-name fields ...)
     (begin
       (define-c-enum gl-name ((include<> "OpenGL/OpenGL.h")) 
         fields ...)))))

(define-syntax define-gl-enum-set 
  (syntax-rules ()
    ((_ gl-name fields ...)
     (define-c-enum-set gl-name ((include<> "OpenGL/OpenGL.h")) 
       fields ...))))

(define-gl-enum-set gl-accum-op-bits
  (accum  "GL_ACCUM")
  (load   "GL_LOAD")
  (return "GL_RETURN")
  (mult   "GL_MULT")
  (add    "GL_ADD"))

(define-gl-enum gl-alpha-function
  (never  "GL_NEVER")
  (<      "GL_LESS")
  (=      "GL_EQUAL")
  (<=     "GL_LEQUAL")
  (>      "GL_GREATER")
  (!=     "GL_NOTEQUAL")
  (>=     "GL_GEQUAL")
  (always "GL_ALWAYS"))

(define-gl-enum-set gl-attrib-bits
  (current         "GL_CURRENT_BIT")
  (point           "GL_POINT_BIT")
  (line            "GL_LINE_BIT")
  (polygon         "GL_POLYGON_BIT")
  (polygon-stipple "GL_POLYGON_STIPPLE_BIT")
  (pixel-mode      "GL_PIXEL_MODE_BIT")
  (lighting        "GL_LIGHTING_BIT")
  (fog             "GL_FOG_BIT")
  (depth-buffer    "GL_DEPTH_BUFFER_BIT")
  (accum-buffer    "GL_ACCUM_BUFFER_BIT")
  (stencil-buffer  "GL_STENCIL_BUFFER_BIT")
  (viewport        "GL_VIEWPORT_BIT")
  (transform       "GL_TRANSFORM_BIT")
  (enable          "GL_ENABLE_BIT")
  (color-buffer    "GL_COLOR_BUFFER_BIT")
  (hint            "GL_HINT_BIT")
  (eval            "GL_EVAL_BIT")
  (list            "GL_LIST_BIT")
  (texture         "GL_TEXTURE_BIT")
  (scissor         "GL_SCISSOR_BIT")
  (all-attrib      "GL_ALL_ATTRIB_BITS"))

(define-gl-enum gl-begin-mode
  (points         "GL_POINTS")
  (lines          "GL_LINES")
  (line-strip     "GL_LINE_STRIP")
  (line-loop      "GL_LINE_LOOP")
  (triangles      "GL_TRIANGLES")
  (triangle-strip "GL_TRIANGLE_STRIP")
  (triangle-fan   "GL_TRIANGLE_FAN")
  (quads          "GL_QUADS")
  (quad-strip     "GL_QUAD_STRIP")
  (polygon        "GL_POLYGON"))

(define-gl-enum gl-blend-equation-mode
  (logic-op "GL_LOGIC_OP")
  (+        "GL_FUNC_ADD")
  (min      "GL_MIN")
  (max      "GL_MAX")
  (-        "GL_FUNC_SUBTRACT")
  (rev-     "GL_FUNC_REVERSE_SUBTRACT"))

(define-gl-enum gl-blending-factor-dest
  (zero                     "GL_ZERO")
  (one                      "GL_ONE")
  (src-color                "GL_SRC_COLOR")
  (one-minus-src-color      "GL_ONE_MINUS_SRC_COLOR")
  (src-alpha                "GL_SRC_ALPHA")
  (one-minus-src-alpha      "GL_ONE_MINUS_SRC_ALPHA")
  (dst-alpha                "GL_DST_ALPHA")
  (one-minus-dst-alpha      "GL_ONE_MINUS_DST_ALPHA")
  (constant-color           "GL_CONSTANT_COLOR")
  (one-minus-constant-color "GL_ONE_MINUS_CONSTANT_COLOR")
  (constant-alpha           "GL_CONSTANT_ALPHA")
  (one-minus-constant-alpha "GL_ONE_MINUS_CONSTANT_ALPHA"))

(define-gl-enum gl-blending-factor-src
  (zero                     "GL_ZERO")
  (one                      "GL_ONE")
  (dst-color                "GL_DST_COLOR")
  (one-minus-dst-color      "GL_ONE_MINUS_DST_COLOR")
  (dst-alpha                "GL_DST_ALPHA")
  (one-minus-dst-alpha      "GL_ONE_MINUS_DST_ALPHA")
  (constant-color           "GL_CONSTANT_COLOR")
  (one-minus-constant-color "GL_ONE_MINUS_CONSTANT_COLOR")
  (constant-alpha           "GL_CONSTANT_ALPHA")
  (one-minus-constant-alpha "GL_ONE_MINUS_CONSTANT_ALPHA"))

(define-gl-enum-set gl-clear-buffer-bits
  (color "GL_COLOR_BUFFER_BIT")
  (depth "GL_DEPTH_BUFFER_BIT")
  (accum "GL_ACCUM_BUFFER_BIT")
  (stencil "GL_STENCIL_BUFFER_BIT"))

(define-gl-enum gl-client-array-type
  (vertex "GL_VERTEX_ARRAY")
  (normal "GL_NORMAL_ARRAY")
  (color  "GL_COLOR_ARRAY")
  (index  "GL_INDEX_ARRAY")
  (texture-coord "GL_TEXTURE_COORD_ARRAY")
  (edge-flag "GL_EDGE_FLAG_ARRAY"))

(define-gl-enum gl-clip-plane-name
  (plane0 "GL_CLIP_PLANE0")
  (plane1 "GL_CLIP_PLANE1")
  (plane2 "GL_CLIP_PLANE2") 
  (plane3 "GL_CLIP_PLANE3")
  (plane4 "GL_CLIP_PLANE4")
  (plane5 "GL_CLIP_PLANE5")) 

(define-gl-enum gl-color-material-face
  (front "GL_FRONT")
  (back  "GL_BACK")
  (front-and-back "GL_FRONT_AND_BACK"))

(define-gl-enum gl-color-material-parameter
  (ambient "GL_AMBIENT")
  (diffuse "GL_DIFFUSE")
  (specular "GL_SPECULAR")
  (emission "GL_EMISSION")
  (ambient-and-diffuse "GL_AMBIENT_AND_DIFFUSE"))

(define-gl-enum gl-color-pointer-type
  (byte   "GL_BYTE")
  (ubyte  "GL_UNSIGNED_BYTE")
  (short  "GL_SHORT")
  (ushort "GL_UNSIGNED_SHORT")
  (int    "GL_INT")
  (uint   "GL_UNSIGNED_INT")
  (float  "GL_FLOAT")
  (double "GL_DOUBLE"))

(define-gl-enum gl-color-table-parameter-pname
  (scale "GL_COLOR_TABLE_SCALE")
  (bias  "GL_COLOR_TABLE_BIAS"))

(define-gl-enum gl-color-table-target
  (standard                "GL_COLOR_TABLE")
  (post-convolution        "GL_POST_CONVOLUTION_COLOR_TABLE")
  (post-color-matrix       "GL_POST_COLOR_MATRIX_COLOR_TABLE")
  (proxy                   "GL_PROXY_COLOR_TABLE")
  (proxy-post-convolution  "GL_PROXY_POST_CONVOLUTION_COLOR_TABLE")
  (proxy-post-color-matrix "GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE"))

(define-gl-enum gl-convolution-border-mode
  (reduce "GL_REDUCE")
  ;; (ignore-border "GL_IGNORE_BORDER") ;; undefined?
  (constant-border "GL_CONSTANT_BORDER"))

(define-gl-enum gl-convolution-parameter
  (border-mode "GL_CONVOLUTION_BORDER_MODE")
  (filter-scale "GL_CONVOLUTION_FILTER_SCALE")
  (filter-bias "GL_CONVOLUTION_FILTER_BIAS"))

(define-gl-enum gl-convolution-target
  (conv-1d "GL_CONVOLUTION_1D")
  (conv-2d "GL_CONVOLUTION_2D"))

(define-gl-enum gl-cull-face-mode
  (front "GL_FRONT")
  (back "GL_BACK")
  (front-and-back "GL_FRONT_AND_BACK"))

(define-gl-enum gl-data-type
  (byte "GL_BYTE") 
  (ubyte "GL_UNSIGNED_BYTE")
  (short "GL_SHORT")
  (ushort "GL_UNSIGNED_SHORT")
  (int "GL_INT")
  (uint "GL_UNSIGNED_INT")
  (float "GL_FLOAT")
  (two-bytes "GL_2_BYTES")
  (three-bytes "GL_3_BYTES")
  (four-bytes "GL_4_BYTES")
  (double "GL_DOUBLE"))

(define-gl-enum gl-depth-function
  (never "GL_NEVER")
  (< "GL_LESS")
  (= "GL_EQUAL")
  (<= "GL_LEQUAL")
  (> "GL_GREATER")
  (!= "GL_NOTEQUAL")
  (>= "GL_GEQUAL")
  (always "GL_ALWAYS"))

(define-gl-enum gl-draw-buffer-mode
  (none "GL_NONE")
  (front-left "GL_FRONT_LEFT")
  (front-right "GL_FRONT_RIGHT")
  (back-left "GL_BACK_LEFT")
  (back-right "GL_BACK_RIGHT")
  (front "GL_FRONT")
  (back "GL_BACK")
  (left "GL_LEFT")
  (right "GL_RIGHT")
  (front-and-back "GL_FRONT_AND_BACK")
  (aux0 "GL_AUX0")
  (aux1 "GL_AUX1")
  (aux2 "GL_AUX2")
  (aux3 "GL_AUX3")) 

(define-gl-enum gl-enable-mode
  (fog "GL_FOG")
  (lighting "GL_LIGHTING")
  (texture-1d "GL_TEXTURE_1D")
  (texture-2d "GL_TEXTURE_2D")
  (line-stipple "GL_LINE_STIPPLE")
  (polygon-stipple "GL_POLYGON_STIPPLE")
  (cull-face "GL_CULL_FACE")
  (alpha-test "GL_ALPHA_TEST")
  (blend "GL_BLEND")
  (index-logic-op "GL_INDEX_LOGIC_OP")
  (color-logic-op "GL_COLOR_LOGIC_OP")
  (dither "GL_DITHER")
  (stencil-test "GL_STENCIL_TEST")
  (depth-test "GL_DEPTH_TEST")
  (clip-plane0 "GL_CLIP_PLANE0")
  (clip-plane1 "GL_CLIP_PLANE1")
  (clip-plane2 "GL_CLIP_PLANE2") 
  (clip-plane3 "GL_CLIP_PLANE3")
  (clip-plane4 "GL_CLIP_PLANE4")
  (clip-planes "GL_CLIP_PLANE5")
  (light0 "GL_LIGHT0")
  (light1 "GL_LIGHT1")
  (light2 "GL_LIGHT2")
  (light3 "GL_LIGHT3")
  (light4 "GL_LIGHT4")
  (light5 "GL_LIGHT5")
  (light6 "GL_LIGHT6")
  (light7 "GL_LIGHT7")
  (texture-gen-5 "GL_TEXTURE_GEN_S")
  (texture-gen-t "GL_TEXTURE_GEN_T")
  (texture-gen-r "GL_TEXTURE_GEN_R")
  (texture-gen-q "GL_TEXTURE_GEN_Q")
  (map1-vertex-3 "GL_MAP1_VERTEX_3")
  (map1-vertex-4 "GL_MAP1_VERTEX_4")
  (map1-color-4 "GL_MAP1_COLOR_4")
  (map1-index "GL_MAP1_INDEX")
  (map1-normal "GL_MAP1_NORMAL")
  (map1-texture-coord-1 "GL_MAP1_TEXTURE_COORD_1")
  (map1-texture-coord-2 "GL_MAP1_TEXTURE_COORD_2")
  (map1-texture-coord-3 "GL_MAP1_TEXTURE_COORD_3")
  (map1-texture-coord-4 "GL_MAP1_TEXTURE_COORD_4")
  (map2-vertex-3 "GL_MAP2_VERTEX_3")
  (map2-vertex-4 "GL_MAP2_VERTEX_4")
  (map2-color-4 "GL_MAP2_COLOR_4")
  (map2-index "GL_MAP2_INDEX")
  (map2-normal "GL_MAP2_NORMAL")
  (map2-texture-coord-1 "GL_MAP2_TEXTURE_COORD_1") 
  (map2-texture-coord-2 "GL_MAP2_TEXTURE_COORD_2")
  (map2-texture-coord-3 "GL_MAP2_TEXTURE_COORD_3")
  (map2-texture-coord-4 "GL_MAP2_TEXTURE_COORD_4")
  (point-smooth "GL_POINT_SMOOTH")
  (line-smooth "GL_LINE_SMOOTH")
  (polygon-smooth "GL_POLYGON_SMOOTH")
  (scissor-test "GL_SCISSOR_TEST")
  (color-material "GL_COLOR_MATERIAL")
  (normalize "GL_NORMALIZE")
  (auto-normal "GL_AUTO_NORMAL")
  (vertex-array "GL_VERTEX_ARRAY")
  (normal-array "GL_NORMAL_ARRAY")
  (color-array "GL_COLOR_ARRAY")
  (index-array "GL_INDEX_ARRAY")
  (texture-coord-array "GL_TEXTURE_COORD_ARRAY")
  (edge-flag-array "GL_EDGE_FLAG_ARRAY")
  (polygon-offset-point "GL_POLYGON_OFFSET_POINT")
  (polygon-offset-line "GL_POLYGON_OFFSET_LINE")
  (polygon-offset-fill "GL_POLYGON_OFFSET_FILL")
  (color-table "GL_COLOR_TABLE")
  (post-convolution-color-table "GL_POST_CONVOLUTION_COLOR_TABLE") 
  (post-color-matrix-color-table "GL_POST_COLOR_MATRIX_COLOR_TABLE")
  (convolution-1d "GL_CONVOLUTION_1D")
  (convolution-2d "GL_CONVOLUTION_2D")
  (separable-2d "GL_SEPARABLE_2D")
  (histogram "GL_HISTOGRAM")
  (minmax "GL_MINMAX")
  (rescale-normal "GL_RESCALE_NORMAL")
  (texture-3d "GL_TEXTURE_3D"))

(define-gl-enum gl-error-code
  (no-error "GL_NO_ERROR")
  (invalid-enum "GL_INVALID_ENUM")
  (invalid-value "GL_INVALID_VALUE")
  (invalid-operation "GL_INVALID_OPERATION")
  (stack-overflow "GL_STACK_OVERFLOW")
  (stack-underflow "GL_STACK_UNDERFLOW")
  (out-of-memory "GL_OUT_OF_MEMORY")
  (table-too-large "GL_TABLE_TOO_LARGE"))

(define-gl-enum gl-feed-back-mode
  (feedback-2d "GL_2D")
  (feedback-3d "GL_3D")
  (feedback-3d-color "GL_3D_COLOR")
  (feedback-3d-color-texture "GL_3D_COLOR_TEXTURE")
  (feedback-4d-color-texture "GL_4D_COLOR_TEXTURE"))

(define-gl-enum gl-feed-back-token
  (pass-through "GL_PASS_THROUGH_TOKEN")
  (point "GL_POINT_TOKEN")
  (line "GL_LINE_TOKEN")
  (polygon "GL_POLYGON_TOKEN")
  (bitmap "GL_BITMAP_TOKEN")
  (draw-pixel "GL_DRAW_PIXEL_TOKEN")
  (copy-pixel "GL_COPY_PIXEL_TOKEN") 
  (line-reset "GL_LINE_RESET_TOKEN"))

(define-gl-enum gl-fog-mode
  (linear "GL_LINEAR")
  (exp    "GL_EXP")
  (exp2   "GL_EXP2"))

(define-gl-enum gl-fog-parameter
  (fog-color    "GL_FOG_COLOR")
  (fog-density  "GL_FOG_DENSITY")
  (fog-end      "GL_FOG_END")
  (fog-index    "GL_FOG_INDEX")
  (fog-mode     "GL_FOG_MODE")
  (fog-start    "GL_FOG_START"))

(define-gl-enum gl-front-face-direction
  (cw  "GL_CW")
  (ccw "GL_CCW"))

(define-gl-enum gl-color-table-parameter-pname
  (scale          "GL_COLOR_TABLE_SCALE")
  (bias           "GL_COLOR_TABLE_BIAS")
  (format         "GL_COLOR_TABLE_FORMAT")
  (width          "GL_COLOR_TABLE_WIDTH")
  (red-size       "GL_COLOR_TABLE_RED_SIZE")
  (green-size     "GL_COLOR_TABLE_GREEN_SIZE")
  (blue-size      "GL_COLOR_TABLE_BLUE_SIZE")
  (alpha-size     "GL_COLOR_TABLE_ALPHA_SIZE")
  (luminance-size "GL_COLOR_TABLE_LUMINANCE_SIZE")
  (intensity-size "GL_COLOR_TABLE_INTENSITY_SIZE"))

(define-gl-enum gl-convolution-parameter-pname
  (border-color          "GL_CONVOLUTION_BORDER_COLOR")
  (border-mode           "GL_CONVOLUTION_BORDER_MODE")
  (filter-scale          "GL_CONVOLUTION_FILTER_SCALE")
  (filter-bias           "GL_CONVOLUTION_FILTER_BIAS")
  (format                "GL_CONVOLUTION_FORMAT")
  (width                 "GL_CONVOLUTION_WIDTH")
  (height                "GL_CONVOLUTION_HEIGHT")
  (max-convolution-width "GL_MAX_CONVOLUTION_WIDTH")
  (max-convolution-height "GL_MAX_CONVOLUTION_HEIGHT"))

(define-gl-enum gl-histogram-parameter-pname
  (width                    "GL_HISTOGRAM_WIDTH")
  (format                   "GL_HISTOGRAM_FORMAT")
  (red-size                 "GL_HISTOGRAM_RED_SIZE")
  (green-size               "GL_HISTOGRAM_GREEN_SIZE") 
  (blue-size                "GL_HISTOGRAM_BLUE_SIZE")
  (alpha-size               "GL_HISTOGRAM_ALPHA_SIZE")
  (histogram-luminance-size "GL_HISTOGRAM_LUMINANCE_SIZE")
  (histogram-sink           "GL_HISTOGRAM_SINK"))

(define-gl-enum gl-map-target
  (coeff  "GL_COEFF")
  (order  "GL_ORDER")
  (domain "GL_DOMAIN"))

(define-gl-enum gl-minmax-parameter-pname
  (format "GL_MINMAX_FORMAT")
  (sink "GL_MINMAX_SINK"))

(define-gl-enum gl-pixel-map
  (i->i "GL_PIXEL_MAP_I_TO_I")
  (s->s "GL_PIXEL_MAP_S_TO_S")
  (i->r "GL_PIXEL_MAP_I_TO_R")
  (i->g "GL_PIXEL_MAP_I_TO_G")
  (i->b "GL_PIXEL_MAP_I_TO_B")
  (i->a "GL_PIXEL_MAP_I_TO_A")
  (r->r "GL_PIXEL_MAP_R_TO_R")
  (g->g "GL_PIXEL_MAP_G_TO_G")
  (b->b "GL_PIXEL_MAP_B_TO_B")
  (a->a "GL_PIXEL_MAP_A_TO_A"))

(define-gl-enum gl-pointer-target
  (vertex         "GL_VERTEX_ARRAY_POINTER")
  (normal         "GL_NORMAL_ARRAY_POINTER")
  (color          "GL_COLOR_ARRAY_POINTER")
  (index          "GL_INDEX_ARRAY_POINTER")
  (texture-coord  "GL_TEXTURE_COORD_ARRAY_POINTER")
  (edge-flag      "GL_EDGE_FLAG_ARRAY_POINTER"))

(define-gl-enum gl-target
  (current-color                 "GL_CURRENT_COLOR") ; iv fv
  (current-index                 "GL_CURRENT_INDEX") ; iv fv
  (current-normal                "GL_CURRENT_NORMAL") ; fv
  (current-texture-coords        "GL_CURRENT_TEXTURE_COORDS") ; fv
  (current-raster-color          "GL_CURRENT_RASTER_COLOR") ; iv fv
  (current-raster-index          "GL_CURRENT_RASTER_INDEX") ; iv fv
  (current-raster-index-coords   "GL_CURRENT_RASTER_TEXTURE_COORDS") 
  (current-raster-position       "GL_CURRENT_RASTER_POSITION") ; fv
  (current-raster-position-valid "GL_CURRENT_RASTER_POSITION_VALID") ; bv
  (current-raster-distance       "GL_CURRENT_RASTER_DISTANCE") ; fv
  (point-smooth                  "GL_POINT_SMOOTH")
  (point-size                    "GL_POINT_SIZE")
  (point-size-range              "GL_POINT_SIZE_RANGE")
  (point-size-granularity        "GL_POINT_SIZE_GRANULARITY")
  (line-smooth                   "GL_LINE_SMOOTH")
  (line-width                    "GL_LINE_WIDTH")
  (line-width-range              "GL_LINE_WIDTH_RANGE")
  (line-width-granularity        "GL_LINE_WIDTH_GRANULARITY")
  (line-stipple                  "GL_LINE_STIPPLE")
  (line-stipple-pattern          "GL_LINE_STIPPLE_PATTERN")
  (line-stipple-repeat           "GL_LINE_STIPPLE_REPEAT")
  (smooth-point-size-range       "GL_SMOOTH_POINT_SIZE_RANGE")
  (smooth-point-size-granularity "GL_SMOOTH_POINT_SIZE_GRANULARITY")
  (smooth-line-width-range       "GL_SMOOTH_LINE_WIDTH_RANGE")
  (smooth-line-width-granularity "GL_SMOOTH_LINE_WIDTH_GRANULARITY")
  (aliased-point-size-range      "GL_ALIASED_POINT_SIZE_RANGE")
  (aliased-line-width-range      "GL_ALIASED_LINE_WIDTH_RANGE")
  (list-mode                     "GL_LIST_MODE")
  (max-list-nesting              "GL_MAX_LIST_NESTING") 
  (list-base                     "GL_LIST_BASE")
  (list-index                    "GL_LIST_INDEX")
  (polygon-mode                  "GL_POLYGON_MODE")
  (polygon-smooth                "GL_POLYGON_SMOOTH")
  (polygon-stipple               "GL_POLYGON_STIPPLE")
  (edge-flag                     "GL_EDGE_FLAG")
  (cull-face                     "GL_CULL_FACE")
  (cull-face-mode                "GL_CULL_FACE_MODE")
  (front-face                    "GL_FRONT_FACE")
  (lighting                      "GL_LIGHTING")
  (light-model-local-viewer      "GL_LIGHT_MODEL_LOCAL_VIEWER")
  (light-model-two-side          "GL_LIGHT_MODEL_TWO_SIDE")
  (light-model-ambient           "GL_LIGHT_MODEL_AMBIENT")
  (shade-model "GL_SHADE_MODEL")
  (color-material-face "GL_COLOR_MATERIAL_FACE")
  (color-material-parameter "GL_COLOR_MATERIAL_PARAMETER")
  (color-material "GL_COLOR_MATERIAL")
  (fog "GL_FOG")
  (fog-index "GL_FOG_INDEX")
  (fog-density "GL_FOG_DENSITY")
  (fog-start "GL_FOG_START")
  (fog-end "GL_FOG_END")
  (fog-mode "GL_FOG_MODE")
  (fog-color "GL_FOG_COLOR")
  (depth-range "GL_DEPTH_RANGE")
  (depth-test "GL_DEPTH_TEST")
  (depth-writemask "GL_DEPTH_WRITEMASK")
  (depth-clear-value "GL_DEPTH_CLEAR_VALUE")
  (depth-func "GL_DEPTH_FUNC")
  (accum-clear-value "GL_ACCUM_CLEAR_VALUE")
  (stencil-test "GL_STENCIL_TEST")
  (stencil-clear-value "GL_STENCIL_CLEAR_VALUE") 
  (stencil-func "GL_STENCIL_FUNC")
  (stencil-value-mask "GL_STENCIL_VALUE_MASK")
  (stencil-fail "GL_STENCIL_FAIL")
  (stencil-pass-depth-fail "GL_STENCIL_PASS_DEPTH_FAIL")
  (stencil-pass-depth-pass "GL_STENCIL_PASS_DEPTH_PASS")
  (stencil-ref "GL_STENCIL_REF")
  (stencil-writemask "GL_STENCIL_WRITEMASK")
  (matrix-mode "GL_MATRIX_MODE")
  (normalize "GL_NORMALIZE")
  (viewport "GL_VIEWPORT")
  (modelview-stack-depth "GL_MODELVIEW_STACK_DEPTH")
  (projection-stack-depth "GL_PROJECTION_STACK_DEPTH")
  (texture-stack-depth "GL_TEXTURE_STACK_DEPTH")
  (modelview-matrix "GL_MODELVIEW_MATRIX")
  (projection-matrix "GL_PROJECTION_MATRIX")
  (texture-matrix "GL_TEXTURE_MATRIX")
  (attrib-stack-depth "GL_ATTRIB_STACK_DEPTH")
  (client-attrib-stack-depth "GL_CLIENT_ATTRIB_STACK_DEPTH")
  (alpha-test "GL_ALPHA_TEST")
  (alpha-test-func "GL_ALPHA_TEST_FUNC")
  (alpha-test-ref "GL_ALPHA_TEST_REF")
  (dither "GL_DITHER")
  (blend-dst "GL_BLEND_DST")
  (blend-src "GL_BLEND_SRC")
  (blend "GL_BLEND")
  (logic-op-mode "GL_LOGIC_OP_MODE")
  (index-logic-op "GL_INDEX_LOGIC_OP")
  (color-logic-op "GL_COLOR_LOGIC_OP")
  (aux-buffers "GL_AUX_BUFFERS")
  (draw-buffer "GL_DRAW_BUFFER")
  (read-buffer "GL_READ_BUFFER")
  (scissor-box "GL_SCISSOR_BOX")
  (scissor-test "GL_SCISSOR_TEST")
  (index-clear-value "GL_INDEX_CLEAR_VALUE")
  (index-writemask "GL_INDEX_WRITEMASK")
  (color-clear-value "GL_COLOR_CLEAR_VALUE")
  (color-writemask "GL_COLOR_WRITEMASK")
  (index-mode "GL_INDEX_MODE")
  (rgba-mode "GL_RGBA_MODE")
  (doublebuffer "GL_DOUBLEBUFFER")
  (stereo "GL_STEREO")
  (render-mode "GL_RENDER_MODE")
  (perspective-correction-hint "GL_PERSPECTIVE_CORRECTION_HINT")
  (point-smooth-hint "GL_POINT_SMOOTH_HINT")
  (line-smooth-hint "GL_LINE_SMOOTH_HINT")
  (polygon-smooth-hint "GL_POLYGON_SMOOTH_HINT")
  (fog-hint "GL_FOG_HINT")
  (texture-gen-s "GL_TEXTURE_GEN_S")
  (texture-gen-t "GL_TEXTURE_GEN_T")
  (texture-gen-r "GL_TEXTURE_GEN_R")
  (texture-gen-q "GL_TEXTURE_GEN_Q")
  (pixel-map-i-to-i "GL_PIXEL_MAP_I_TO_I")
  (pixel-map-s-to-s "GL_PIXEL_MAP_S_TO_S")
  (pixel-map-i-to-r "GL_PIXEL_MAP_I_TO_R")
  (pixel-map-i-to-g "GL_PIXEL_MAP_I_TO_G")
  (pixel-map-i-to-b "GL_PIXEL_MAP_I_TO_B")
  (pixel-map-i-to-a "GL_PIXEL_MAP_I_TO_A")
  (pixel-map-r-to-r "GL_PIXEL_MAP_R_TO_R")
  (pixel-map-g-to-g "GL_PIXEL_MAP_G_TO_G")
  (pixel-map-b-to-b "GL_PIXEL_MAP_B_TO_B")
  (pixel-map-a-to-a "GL_PIXEL_MAP_A_TO_A")
  (pixel-map-i-to-i-size "GL_PIXEL_MAP_I_TO_I_SIZE")
  (pixel-map-s-to-s-size "GL_PIXEL_MAP_S_TO_S_SIZE")
  (pixel-map-i-to-r-size "GL_PIXEL_MAP_I_TO_R_SIZE")
  (pixel-map-i-to-g-size "GL_PIXEL_MAP_I_TO_G_SIZE")
  (pixel-map-i-to-b-size "GL_PIXEL_MAP_I_TO_B_SIZE")
  (pixel-map-i-to-a-size "GL_PIXEL_MAP_I_TO_A_SIZE")
  (pixel-map-r-to-r-size "GL_PIXEL_MAP_R_TO_R_SIZE")
  (pixel-map-g-to-g-size "GL_PIXEL_MAP_G_TO_G_SIZE")
  (pixel-map-b-to-b-size "GL_PIXEL_MAP_B_TO_B_SIZE")
  (pixel-map-a-to-a-size "GL_PIXEL_MAP_A_TO_A_SIZE")
  (unpack-swap-bytes "GL_UNPACK_SWAP_BYTES")
  (unpack-lsb-first "GL_UNPACK_LSB_FIRST")
  (unpack-row-length "GL_UNPACK_ROW_LENGTH")
  (unpack-skip-rows "GL_UNPACK_SKIP_ROWS")
  (unpack-skip-pixels "GL_UNPACK_SKIP_PIXELS")
  (unpack-alignment "GL_UNPACK_ALIGNMENT")
  (pack-swap-bytes "GL_PACK_SWAP_BYTES")
  (pack-lsb-first "GL_PACK_LSB_FIRST")
  (pack-row-length "GL_PACK_ROW_LENGTH")
  (pack-skip-rows "GL_PACK_SKIP_ROWS")
  (pack-skip-pixels "GL_PACK_SKIP_PIXELS")
  (pack-alignment "GL_PACK_ALIGNMENT")
  (map-color "GL_MAP_COLOR")
  (map-stencil "GL_MAP_STENCIL")
  (index-shift "GL_INDEX_SHIFT")
  (index-offset "GL_INDEX_OFFSET")
  (red-scale "GL_RED_SCALE")
  (red-bias "GL_RED_BIAS")
  (zoom-x "GL_ZOOM_X")
  (zoom-y "GL_ZOOM_Y")
  (green-scale "GL_GREEN_SCALE")
  (green-bias "GL_GREEN_BIAS")
  (blue-scale "GL_BLUE_SCALE")
  (blue-bias "GL_BLUE_BIAS")
  (alpha-scale "GL_ALPHA_SCALE")
  (alpha-bias "GL_ALPHA_BIAS")
  (depth-scale "GL_DEPTH_SCALE")
  (depth-bias "GL_DEPTH_BIAS")
  (max-eval-order "GL_MAX_EVAL_ORDER")
  (max-lights "GL_MAX_LIGHTS")
  (max-clip-planes "GL_MAX_CLIP_PLANES")
  (max-texture-size "GL_MAX_TEXTURE_SIZE")
  (max-pixel-map-table "GL_MAX_PIXEL_MAP_TABLE")
  (max-attrib-stack-depth "GL_MAX_ATTRIB_STACK_DEPTH")
  (max-modelview-stack-depth "GL_MAX_MODELVIEW_STACK_DEPTH")
  (max-name-stack-depth "GL_MAX_NAME_STACK_DEPTH")
  (max-projection-stack-depth "GL_MAX_PROJECTION_STACK_DEPTH")
  (max-texture-stack-depth "GL_MAX_TEXTURE_STACK_DEPTH")
  (max-viewport-dims "GL_MAX_VIEWPORT_DIMS")
  (max-client-attrib-stack-depth "GL_MAX_CLIENT_ATTRIB_STACK_DEPTH")
  (subpixel-bits "GL_SUBPIXEL_BITS")
  (index-bits "GL_INDEX_BITS")
  (red-bits "GL_RED_BITS")
  (green-bits "GL_GREEN_BITS")
  (blue-bits "GL_BLUE_BITS")
  (alpha-bits "GL_ALPHA_BITS")
  (depth-bits "GL_DEPTH_BITS")
  (stencil-bits "GL_STENCIL_BITS")
  (accum-red-bits "GL_ACCUM_RED_BITS")
  (accum-green-bits "GL_ACCUM_GREEN_BITS")
  (accum-blue-bits "GL_ACCUM_BLUE_BITS")
  (accum-alpha-bits "GL_ACCUM_ALPHA_BITS")
  (name-stack-depth "GL_NAME_STACK_DEPTH")
  (auto-normal "GL_AUTO_NORMAL")
  (map1-color-4 "GL_MAP1_COLOR_4")
  (map1-index "GL_MAP1_INDEX")
  (map1-normal "GL_MAP1_NORMAL")
  (map1-texture-coord-1 "GL_MAP1_TEXTURE_COORD_1")
  (map1-texture-coord-2 "GL_MAP1_TEXTURE_COORD_2")
  (map1-texture-coord-3 "GL_MAP1_TEXTURE_COORD_3")
  (map1-texture-coord-4 "GL_MAP1_TEXTURE_COORD_4")
  (map1-vertex-3 "GL_MAP1_VERTEX_3")
  (map1-vertex-4 "GL_MAP1_VERTEX_4")
  (map2-color-4 "GL_MAP2_COLOR_4")
  (map2-index "GL_MAP2_INDEX")
  (map2-normal "GL_MAP2_NORMAL")
  (map2-texture-coord-1 "GL_MAP2_TEXTURE_COORD_1")
  (map2-texture-coord-2 "GL_MAP2_TEXTURE_COORD_2")
  (map2-texture-coord-3 "GL_MAP2_TEXTURE_COORD_3")
  (map2-texture-coord-4 "GL_MAP2_TEXTURE_COORD_4")
  (map2-vertex-3 "GL_MAP2_VERTEX_3")
  (map2-vertex-4 "GL_MAP2_VERTEX_4")
  (map1-grid-domain "GL_MAP1_GRID_DOMAIN")
  (map1-grid-segments "GL_MAP1_GRID_SEGMENTS")
  (map2-grid-domain "GL_MAP2_GRID_DOMAIN")
  (map2-grid-segments "GL_MAP2_GRID_SEGMENTS")
  (texture-1d "GL_TEXTURE_1D")
  (texture-2d "GL_TEXTURE_2D")
  (feedback-buffer-pointer "GL_FEEDBACK_BUFFER_POINTER")
  (feedback-buffer-size "GL_FEEDBACK_BUFFER_SIZE")
  (feedback-buffer-type "GL_FEEDBACK_BUFFER_TYPE")
  (selection-buffer-pointer "GL_SELECTION_BUFFER_POINTER")
  (selection-buffer-size "GL_SELECTION_BUFFER_SIZE")
  (texture-binding-1d "GL_TEXTURE_BINDING_1D")
  (texture-binding-2d "GL_TEXTURE_BINDING_2D")
  (texture-binding-3d "GL_TEXTURE_BINDING_3D")
  (vertex-array "GL_VERTEX_ARRAY")
  (normal-array "GL_NORMAL_ARRAY")
  (color-array "GL_COLOR_ARRAY")
  (index-array "GL_INDEX_ARRAY")
  (texture-coord-array "GL_TEXTURE_COORD_ARRAY")
  (edge-flag-array "GL_EDGE_FLAG_ARRAY")
  (vertex-array-size "GL_VERTEX_ARRAY_SIZE")
  (vertex-array-type "GL_VERTEX_ARRAY_TYPE")
  (vertex-array-stride "GL_VERTEX_ARRAY_STRIDE")
  (normal-array-type "GL_NORMAL_ARRAY_TYPE")
  (normal-array-stride "GL_NORMAL_ARRAY_STRIDE")
  (color-array-size "GL_COLOR_ARRAY_SIZE")
  (color-array-type "GL_COLOR_ARRAY_TYPE")
  (color-array-stride "GL_COLOR_ARRAY_STRIDE")
  (index-array-type "GL_INDEX_ARRAY_TYPE")
  (index-array-stride "GL_INDEX_ARRAY_STRIDE")
  (texture-coord-array-size "GL_TEXTURE_COORD_ARRAY_SIZE")
  (texture-coord-array-type "GL_TEXTURE_COORD_ARRAY_TYPE")
  (texture-coord-array-stride "GL_TEXTURE_COORD_ARRAY_STRIDE")
  (edge-flag-array-stride "GL_EDGE_FLAG_ARRAY_STRIDE")
  (polygon-offset-factor "GL_POLYGON_OFFSET_FACTOR")
  (polygon-offset-units "GL_POLYGON_OFFSET_UNITS")
  (color-table "GL_COLOR_TABLE")
  (post-convolution-color-table "GL_POST_CONVOLUTION_COLOR_TABLE")
  (post-color-matrix-color-table "GL_POST_COLOR_MATRIX_COLOR_TABLE")
  (convolution-1d "GL_CONVOLUTION_1D")
  (convolution-2d "GL_CONVOLUTION_2D")
  (separable-2d "GL_SEPARABLE_2D")
  (post-convolution-red-scale "GL_POST_CONVOLUTION_RED_SCALE")
  (post-convolution-green-scale "GL_POST_CONVOLUTION_GREEN_SCALE")
  (post-convolution-blue-scale "GL_POST_CONVOLUTION_BLUE_SCALE")
  (post-convolution-alpha-scale "GL_POST_CONVOLUTION_ALPHA_SCALE")
  (post-convolution-red-bias "GL_POST_CONVOLUTION_RED_BIAS")
  (post-convolution-green-bias "GL_POST_CONVOLUTION_GREEN_BIAS")
  (post-convolution-blue-bias "GL_POST_CONVOLUTION_BLUE_BIAS")
  (post-convolution-alpha-bias "GL_POST_CONVOLUTION_ALPHA_BIAS")
  (color-matrix "GL_COLOR_MATRIX")
  (color-matrix-stack-depth "GL_COLOR_MATRIX_STACK_DEPTH")
  (max-color-matrix-stack-depth "GL_MAX_COLOR_MATRIX_STACK_DEPTH")
  (post-color-matrix-red-scale "GL_POST_COLOR_MATRIX_RED_SCALE")
  (post-color-matrix-green-scale "GL_POST_COLOR_MATRIX_GREEN_SCALE")
  (post-color-matrix-blue-scale "GL_POST_COLOR_MATRIX_BLUE_SCALE")
  (post-color-matrix-alpha-scale "GL_POST_COLOR_MATRIX_ALPHA_SCALE")
  (post-color-matrix-red-bias "GL_POST_COLOR_MATRIX_RED_BIAS")
  (post-color-matrix-green-bias "GL_POST_COLOR_MATRIX_GREEN_BIAS")
  (post-color-matrix-blue-bias "GL_POST_COLOR_MATRIX_BLUE_BIAS")
  (post-color-matrix-alpha-bias "GL_POST_COLOR_MATRIX_ALPHA_BIAS")
  (histogram "GL_HISTOGRAM")
  (minmax "GL_MINMAX")
  (max-elements-vertices "GL_MAX_ELEMENTS_VERTICES")
  (max-elements-indices "GL_MAX_ELEMENTS_INDICES")
  (rescale-normal "GL_RESCALE_NORMAL")
  (light-model-color-control "GL_LIGHT_MODEL_COLOR_CONTROL")
  (pack-skip-images "GL_PACK_SKIP_IMAGES")
  (pack-image-height "GL_PACK_IMAGE_HEIGHT")
  (unpack-skip-images "GL_UNPACK_SKIP_IMAGES")
  (unpack-image-height "GL_UNPACK_IMAGE_HEIGHT")
  (texture-3d "GL_TEXTURE_3D")
  (max-3d-texture-size "GL_MAX_3D_TEXTURE_SIZE")
  (blend-color "GL_BLEND_COLOR")
  (blend-equation "GL_BLEND_EQUATION"))

(define-gl-enum gl-texture-parameter
  (mag-filter "GL_TEXTURE_MAG_FILTER")
  (min-filter "GL_TEXTURE_MIN_FILTER")
  (wrap-s "GL_TEXTURE_WRAP_S")
  (wrap-t "GL_TEXTURE_WRAP_T")
  (width "GL_TEXTURE_WIDTH")
  (height "GL_TEXTURE_HEIGHT")
  (internal-format "GL_TEXTURE_INTERNAL_FORMAT")
  (border-color "GL_TEXTURE_BORDER_COLOR")
  (border "GL_TEXTURE_BORDER")
  (red-size "GL_TEXTURE_RED_SIZE")
  (green-size "GL_TEXTURE_GREEN_SIZE")
  (blue-size "GL_TEXTURE_BLUE_SIZE")
  (alpha-size "GL_TEXTURE_ALPHA_SIZE")
  (luminance-size "GL_TEXTURE_LUMINANCE_SIZE")
  (intensity-size "GL_TEXTURE_INTENSITY_SIZE")
  (priority "GL_TEXTURE_PRIORITY")
  (resident "GL_TEXTURE_RESIDENT")
  (depth "GL_TEXTURE_DEPTH")
  (wrap-r "GL_TEXTURE_WRAP_R")
  (min-lod "GL_TEXTURE_MIN_LOD")
  (max-lod "GL_TEXTURE_MAX_LOD")
  (base-level "GL_TEXTURE_BASE_LEVEL")
  (max-level "GL_TEXTURE_MAX_LEVEL"))

(define-gl-enum gl-hint-mode
  (dont-care "GL_DONT_CARE")
  (fastest "GL_FASTEST")
  (nicest "GL_NICEST"))

(define-gl-enum gl-hint-target
  (perspective-correction-hint "GL_PERSPECTIVE_CORRECTION_HINT")
  (point-smooth-hint "GL_POINT_SMOOTH_HINT")
  (line-smooth-hint "GL_LINE_SMOOTH_HINT")
  (polygon-smooth-hint "GL_POLYGON_SMOOTH_HINT")
  (fog-hint "GL_FOG_HINT"))

(define-gl-enum gl-histogram-target 
  (histogram "GL_HISTOGRAM")
  (proxy-histogram "GL_PROXY_HISTOGRAM"))

(define-gl-enum gl-index-pointer-type
  (ubyte "GL_UNSIGNED_BYTE")
  (short "GL_SHORT")
  (int "GL_INT")
  (float "GL_FLOAT")
  (double "GL_DOUBLE"))

(define-gl-enum gl-light-model-color-control
  (single-color "GL_SINGLE_COLOR")
  (separate-specular-color "GL_SEPARATE_SPECULAR_COLOR"))

(define-gl-enum gl-light-model-parameter 
  (ambient "GL_LIGHT_MODEL_AMBIENT")
  (local-viewer "GL_LIGHT_MODEL_LOCAL_VIEWER")
  (two-side "GL_LIGHT_MODEL_TWO_SIDE")
  (color-control "GL_LIGHT_MODEL_COLOR_CONTROL"))

(define-gl-enum gl-light-name
  (light0 "GL_LIGHT0")
  (light1 "GL_LIGHT1")
  (light2 "GL_LIGHT2")
  (light3 "GL_LIGHT3")
  (light4 "GL_LIGHT4")
  (light5 "GL_LIGHT5")
  (light6 "GL_LIGHT6")
  (light7 "GL_LIGHT7"))

(define-gl-enum gl-light-parameter
  (ambient "GL_AMBIENT")
  (diffuse "GL_DIFFUSE")
  (specular "GL_SPECULAR")
  (position "GL_POSITION")
  (spot-direction "GL_SPOT_DIRECTION")
  (spot-exponent "GL_SPOT_EXPONENT")
  (spot-cutoff "GL_SPOT_CUTOFF")
  (constant-attenuation "GL_CONSTANT_ATTENUATION")
  (linear-attenuation "GL_LINEAR_ATTENUATION")
  (quadratic-attenuation "GL_QUADRATIC_ATTENUATION"))

(define-gl-enum gl-interleaved-arrays-enum
  (v2f "GL_V2F")
  (v3f "GL_V3F")
  (c4ub-v2f "GL_C4UB_V2F")
  (c4ub-v3f "GL_C4UB_V3F")
  (c3f-v3f "GL_C3F_V3F")
  (n3f-v3f "GL_N3F_V3F")
  (c4f-n3f-v3f "GL_C4F_N3F_V3F")
  (t2f-v3f "GL_T2F_V3F")
  (t4f-v4f "GL_T4F_V4F")
  (t2f-c4ub-v3f "GL_T2F_C4UB_V3F")
  (t2f-c3f-v3f "GL_T2F_C3F_V3F")
  (t2f-n3f-v3f "GL_T2F_N3F_V3F")
  (t2f-c4f-n3f-v3f "GL_T2F_C4F_N3F_V3F")
  (t4f-c4f-n3f-v4f "GL_T4F_C4F_N3F_V4F"))

(define-gl-enum gl-list-mode
  (compile "GL_COMPILE")
  (compile-and-execute "GL_COMPILE_AND_EXECUTE"))

(define-gl-enum gl-list-name-type 
  (byte "GL_BYTE")
  (ubyte "GL_UNSIGNED_BYTE")
  (short "GL_SHORT")
  (ushort "GL_UNSIGNED_SHORT")
  (int "GL_INT")
  (uint "GL_UNSIGNED_INT")
  (float "GL_FLOAT")
  (two-bytes "GL_2_BYTES")
  (three-bytes "GL_3_BYTES")
  (four-bytes "GL_4_BYTES"))

(define-gl-enum gl-logic-op
  (clear "GL_CLEAR")
  (and "GL_AND")
  (and-reverse "GL_AND_REVERSE")
  (copy "GL_COPY")
  (and-inverted "GL_AND_INVERTED")
  (noop "GL_NOOP")
  (xor "GL_XOR")
  (or "GL_OR")
  (nor "GL_NOR")
  (equiv "GL_EQUIV")
  (invert "GL_INVERT")
  (or-reverse "GL_OR_REVERSE")
  (copy-inverted "GL_COPY_INVERTED")
  (or-inverted "GL_OR_INVERTED")
  (nand "GL_NAND")
  (set "GL_SET"))

(define-gl-enum gl-map-target 
  (map1-color-4 "GL_MAP1_COLOR_4")
  (map1-index "GL_MAP1_INDEX")
  (map1-normal "GL_MAP1_NORMAL")
  (map1-texture-coord-1 "GL_MAP1_TEXTURE_COORD_1")
  (map1-texture-coord-2 "GL_MAP1_TEXTURE_COORD_2")
  (map1-texture-coord-3 "GL_MAP1_TEXTURE_COORD_3")
  (map1-texture-coord-4 "GL_MAP1_TEXTURE_COORD_4")
  (map1-vertex-3 "GL_MAP1_VERTEX_3")
  (map1-vertex-4 "GL_MAP1_VERTEX_4")
  (map2-color-4 "GL_MAP2_COLOR_4")
  (map2-index "GL_MAP2_INDEX")
  (map2-normal "GL_MAP2_NORMAL")
  (map2-texture-coord-1 "GL_MAP2_TEXTURE_COORD_1")
  (map2-texture-coord-2 "GL_MAP2_TEXTURE_COORD_2")
  (map2-texture-coord-3 "GL_MAP2_TEXTURE_COORD_3")
  (map2-texture-coord-4 "GL_MAP2_TEXTURE_COORD_4")
  (map2-vertex-3 "GL_MAP2_VERTEX_3")
  (map2-vertex-4 "GL_MAP2_VERTEX_4"))

(define-gl-enum gl-material-face 
  (front "GL_FRONT")
  (back "GL_BACK")
  (front-and-back "GL_FRONT_AND_BACK"))

(define-gl-enum gl-material-parameter 
  (emission "GL_EMISSION")
  (shininess "GL_SHININESS")
  (ambient-and-diffuse "GL_AMBIENT_AND_DIFFUSE")
  (color-indexes "GL_COLOR_INDEXES")
  (ambient "GL_AMBIENT")
  (diffuse "GL_DIFFUSE")
  (specular "GL_SPECULAR"))

(define-gl-enum gl-matrix-mode-enum
  (modelview "GL_MODELVIEW")
  (projection "GL_PROJECTION")
  (texture "GL_TEXTURE"))

(define-gl-enum gl-mesh-mode1
  (point "GL_POINT")
  (line "GL_LINE"))

(define-gl-enum gl-mesh-mode2
  (point "GL_POINT")
  (line "GL_LINE")
  (fill "GL_FILL"))

(define-gl-enum gl-minmax-target
  (minmax "GL_MINMAX"))

(define-gl-enum gl-normal-pointer-type
  (byte "GL_BYTE")
  (short "GL_SHORT")
  (int "GL_INT")
  (float "GL_FLOAT")
  (double "GL_DOUBLE"))

(define-gl-enum gl-pixel-copy-type
  (color "GL_COLOR")
  (depth "GL_DEPTH")
  (stencil "GL_STENCIL"))

(define-gl-enum gl-pixel-format
  (color-index "GL_COLOR_INDEX")
  (stencil-index "GL_STENCIL_INDEX")
  (depth-component "GL_DEPTH_COMPONENT")
  (red "GL_RED")
  (green "GL_GREEN")
  (blue "GL_BLUE")
  (alpha "GL_ALPHA")
  (rgb "GL_RGB")
  (rgba "GL_RGBA")
  (luminance "GL_LUMINANCE")
  (luminance-alpha "GL_LUMINANCE_ALPHA")
  ;(abgr "GL_ABGR") ; undefined?
  )

(define-gl-enum gl-pixel-internal-format
  (alpha4 "GL_ALPHA4")
  (alpha8 "GL_ALPHA8")
  (alpha12 "GL_ALPHA12")
  (alpha16 "GL_ALPHA16")
  (luminance4 "GL_LUMINANCE4")
  (luminance8 "GL_LUMINANCE8")
  (luminance12 "GL_LUMINANCE12")
  (luminance16 "GL_LUMINANCE16")
  (luminance4-alpha4 "GL_LUMINANCE4_ALPHA4")
  (luminance6-alpha2 "GL_LUMINANCE6_ALPHA2")
  (luminance8-alpha8 "GL_LUMINANCE8_ALPHA8")
  (luminance12-alpha4 "GL_LUMINANCE12_ALPHA4")
  (luminance12-alpha12 "GL_LUMINANCE12_ALPHA12")
  (luminance16-alpha16 "GL_LUMINANCE16_ALPHA16")
  (intensity "GL_INTENSITY")
  (intensity4 "GL_INTENSITY4")
  (intensity8 "GL_INTENSITY8")
  (intensity12 "GL_INTENSITY12")
  (intensity16 "GL_INTENSITY16")
  (r3-g3-b2 "GL_R3_G3_B2")
  (rgb4 "GL_RGB4")
  (rgb5 "GL_RGB5")
  (rgb8 "GL_RGB8")
  (rgb10 "GL_RGB10")
  (rgb12 "GL_RGB12")
  (rgb16 "GL_RGB16")
  (rgba2 "GL_RGBA2")
  (rgba4 "GL_RGBA4")
  (rgb5-a1 "GL_RGB5_A1")
  (rgba8 "GL_RGBA8")
  (rgb10-a2 "GL_RGB10_A2")
  (rgba12 "GL_RGBA12")
  (rgba16 "GL_RGBA16"))

(define-gl-enum gl-pixel-map
  (i->i "GL_PIXEL_MAP_I_TO_I")
  (s->s "GL_PIXEL_MAP_S_TO_S")
  (i->r "GL_PIXEL_MAP_I_TO_R")
  (i->g "GL_PIXEL_MAP_I_TO_G")
  (i->b "GL_PIXEL_MAP_I_TO_B")
  (i->a "GL_PIXEL_MAP_I_TO_A")
  (r->r "GL_PIXEL_MAP_R_TO_R")
  (g->g "GL_PIXEL_MAP_G_TO_G")
  (b->b "GL_PIXEL_MAP_B_TO_B")
  (a->a "GL_PIXEL_MAP_A_TO_A"))

(define-gl-enum gl-pixel-store
  (unpack-swap-bytes "GL_UNPACK_SWAP_BYTES")
  (unpack-lsb-first "GL_UNPACK_LSB_FIRST")
  (unpack-row-length "GL_UNPACK_ROW_LENGTH")
  (unpack-skip-rows "GL_UNPACK_SKIP_ROWS")
  (unpack-skip-pixels "GL_UNPACK_SKIP_PIXELS")
  (unpack-alignment "GL_UNPACK_ALIGNMENT")
  (pack-swap-bytes "GL_PACK_SWAP_BYTES")
  (pack-lsb-first "GL_PACK_LSB_FIRST")
  (pack-row-length "GL_PACK_ROW_LENGTH")
  (pack-skip-rows "GL_PACK_SKIP_ROWS")
  (pack-skip-pixels "GL_PACK_SKIP_PIXELS")
  (pack-alignment "GL_PACK_ALIGNMENT")
  (pack-skip-images "GL_PACK_SKIP_IMAGES")
  (pack-image-height "GL_PACK_IMAGE_HEIGHT")
  (unpack-skip-images "GL_UNPACK_SKIP_IMAGES")
  (unpack-image-height "GL_UNPACK_IMAGE_HEIGHT"))

(define-gl-enum gl-pixel-transfer
  (map-color "GL_MAP_COLOR")
  (map-stencil "GL_MAP_STENCIL")
  (index-shift "GL_INDEX_SHIFT")
  (index-offset "GL_INDEX_OFFSET")
  (red-scale "GL_RED_SCALE")
  (red-bias "GL_RED_BIAS")
  (green-scale "GL_GREEN_SCALE")
  (green-bias "GL_GREEN_BIAS")
  (blue-scale "GL_BLUE_SCALE")
  (blue-bias "GL_BLUE_BIAS")
  (alpha-scale "GL_ALPHA_SCALE")
  (alpha-bias "GL_ALPHA_BIAS")
  (depth-scale "GL_DEPTH_SCALE")
  (depth-bias "GL_DEPTH_BIAS")
  (post-convolution-red-scale "GL_POST_CONVOLUTION_RED_SCALE")
  (post-convolution-green-scale "GL_POST_CONVOLUTION_GREEN_SCALE")
  (post-convolution-blue-scale "GL_POST_CONVOLUTION_BLUE_SCALE")
  (post-convolution-alpha-scale "GL_POST_CONVOLUTION_ALPHA_SCALE")
  (post-convolution-red-bias "GL_POST_CONVOLUTION_RED_BIAS")
  (post-convolution-green-bias "GL_POST_CONVOLUTION_GREEN_BIAS")
  (post-convolution-blue-bias "GL_POST_CONVOLUTION_BLUE_BIAS")
  (post-convolution-alpha-bias "GL_POST_CONVOLUTION_ALPHA_BIAS")
  (post-color-matrix-red-scale "GL_POST_COLOR_MATRIX_RED_SCALE")
  (post-color-matrix-green-scale "GL_POST_COLOR_MATRIX_GREEN_SCALE")
  (post-color-matrix-blue-scale "GL_POST_COLOR_MATRIX_BLUE_SCALE")
  (post-color-matrix-alpha-scale "GL_POST_COLOR_MATRIX_ALPHA_SCALE")
  (post-color-matrix-red-bias "GL_POST_COLOR_MATRIX_RED_BIAS")
  (post-color-matrix-green-bias "GL_POST_COLOR_MATRIX_GREEN_BIAS")
  (post-color-matrix-blue-bias "GL_POST_COLOR_MATRIX_BLUE_BIAS")
  (post-color-matrix-alpha-bias "GL_POST_COLOR_MATRIX_ALPHA_BIAS"))

(define-gl-enum gl-pixel-type
  (bitmap "GL_BITMAP")
  (byte "GL_BYTE")
  (ubyte "GL_UNSIGNED_BYTE")
  (short "GL_SHORT")
  (ushort "GL_UNSIGNED_SHORT")
  (int "GL_INT")
  (uint "GL_UNSIGNED_INT")
  (float "GL_FLOAT")
  (bgr "GL_BGR")
  (bgra "GL_BGRA")
  (ubyte-3-3-2 "GL_UNSIGNED_BYTE_3_3_2")
  (ushort-4-4-4-4 "GL_UNSIGNED_SHORT_4_4_4_4")
  (ushort-5-5-5-1 "GL_UNSIGNED_SHORT_5_5_5_1")
  (uint-8-8-8-8 "GL_UNSIGNED_INT_8_8_8_8")
  (uint-10-10-10-2 "GL_UNSIGNED_INT_10_10_10_2")
  (ushort-5-6-5 "GL_UNSIGNED_SHORT_5_6_5")
  (ubyte-2-3-3-rev "GL_UNSIGNED_BYTE_2_3_3_REV")
  (ushort-5-6-5-rev "GL_UNSIGNED_SHORT_5_6_5_REV")
  (ushort-4-4-4-4-rev "GL_UNSIGNED_SHORT_4_4_4_4_REV")
  (ushort-1-5-5-5-rev "GL_UNSIGNED_SHORT_1_5_5_5_REV")
  (uint-8-8-8-8-rev "GL_UNSIGNED_INT_8_8_8_8_REV")
  (uint-2-10-10-10-rev "GL_UNSIGNED_INT_2_10_10_10_REV"))

(define-gl-enum gl-polygon-mode-enum
  (point "GL_POINT")
  (line "GL_LINE")
  (fill "GL_FILL"))

(define-gl-enum gl-read-buffer-mode
  (front-left "GL_FRONT_LEFT")
  (front-right "GL_FRONT_RIGHT")
  (back-left "GL_BACK_LEFT")
  (back-right "GL_BACK_RIGHT")
  (front "GL_FRONT")
  (back "GL_BACK")
  (left "GL_LEFT")
  (right "GL_RIGHT")
  (aux0 "GL_AUX0")
  (aux1 "GL_AUX1")
  (aux2 "GL_AUX2")
  (aux3 "GL_AUX3"))

(define-gl-enum gl-rendering-mode 
  (render "GL_RENDER")
  (feedback "GL_FEEDBACK")
  (select "GL_SELECT"))

(define-gl-enum gl-separable-target
  (separable-2d "GL_SEPARABLE_2D"))

(define-gl-enum gl-shading-model-enum
  (flat "GL_FLAT")
  (smooth "GL_SMOOTH"))

(define-gl-enum gl-stencil-function
  (never "GL_NEVER")
  (< "GL_LESS")
  (= "GL_EQUAL")
  (<= "GL_LEQUAL")
  (> "GL_GREATER")
  (!= "GL_NOTEQUAL")
  (>= "GL_GEQUAL")
  (always "GL_ALWAYS"))

(define-gl-enum gl-stencil-op
  (zero "GL_ZERO")
  (keep "GL_KEEP")
  (replace "GL_REPLACE")
  (incr "GL_INCR")
  (decr "GL_DECR")
  (invert "GL_INVERT"))

(define-gl-enum gl-string-name
  (vendor "GL_VENDOR")
  (renderer "GL_RENDERER")
  (version "GL_VERSION")
  (extensions "GL_EXTENSIONS"))

(define-gl-enum gl-texture-coord-name
  (s "GL_S")
  (t "GL_T")
  (r "GL_R")
  (q "GL_Q"))

(define-gl-enum gl-tex-coord-pointer-type
  (short "GL_SHORT")
  (int "GL_INT")
  (float "GL_FLOAT")
  (double "GL_DOUBLE"))

(define-gl-enum gl-texture-env-mode 
  (modulate "GL_MODULATE")
  (decal "GL_DECAL")
  (blend "GL_BLEND")
  (replace "GL_REPLACE"))

(define-gl-enum gl-texture-env-parameter 
  (mode "GL_TEXTURE_ENV_MODE")
  (color "GL_TEXTURE_ENV_COLOR"))

(define-gl-enum gl-texture-env-target
  (env "GL_TEXTURE_ENV"))

(define-gl-enum gl-texture-gen-mode 
  (eye-linear "GL_EYE_LINEAR")
  (object-linear "GL_OBJECT_LINEAR")
  (sphere-map "GL_SPHERE_MAP"))

(define-gl-enum gl-texture-gen-parameter 
  (texture-gen-mode "GL_TEXTURE_GEN_MODE")
  (object-plane "GL_OBJECT_PLANE")
  (eye-plane "GL_EYE_PLANE"))

(define-gl-enum gl-texture-mag-filter 
  (nearest "GL_NEAREST")
  (linear "GL_LINEAR"))

(define-gl-enum gl-texture-min-filter
  (nearest "GL_NEAREST")
  (linear "GL_LINEAR")
  (nearest-mipmap-nearest "GL_NEAREST_MIPMAP_NEAREST")
  (linear-mipmap-nearest "GL_LINEAR_MIPMAP_NEAREST")
  (nearest-mipmap-linear "GL_NEAREST_MIPMAP_LINEAR")
  (linear-mipmap-linear "GL_LINEAR_MIPMAP_LINEAR"))

(define-gl-enum gl-texture-parameter-name
  (mag-filter "GL_TEXTURE_MAG_FILTER")
  (min-filter "GL_TEXTURE_MIN_FILTER")
  (wrap-s "GL_TEXTURE_WRAP_S")
  (wrap-t "GL_TEXTURE_WRAP_T")
  (border-color "GL_TEXTURE_BORDER_COLOR")
  (priority "GL_TEXTURE_PRIORITY")
  (wrap-r "GL_TEXTURE_WRAP_R")
  (min-lod "GL_TEXTURE_MIN_LOD")
  (max-lod "GL_TEXTURE_MAX_LOD")
  (base-level "GL_TEXTURE_BASE_LEVEL")
  (max-level "GL_TEXTURE_MAX_LEVEL"))

(define-gl-enum gl-texture-target
  (texture-1d "GL_TEXTURE_1D")
  (texture-2d "GL_TEXTURE_2D")
  (proxy-texture-1d "GL_PROXY_TEXTURE_1D")
  (proxy-texture-2d "GL_PROXY_TEXTURE_2D")
  (texture-3d "GL_TEXTURE_3D")
  (proxy-texture-3d "GL_PROXY_TEXTURE_3D"))

(define-gl-enum gl-texture-wrap-mode
  (clamp "GL_CLAMP")
  (repeat "GL_REPEAT")
  (clamp-to-edge "GL_CLAMP_TO_EDGE"))

(define-gl-enum gl-vertex-pointer-type
  (short "GL_SHORT")
  (int "GL_INT")
  (float "GL_FLOAT")
  (double "GL_DOUBLE"))

(define-gl-enum-set gl-client-attrib-bits
  (pixel-store-bit "GL_CLIENT_PIXEL_STORE_BIT")
  (vertex-array-bit "GL_CLIENT_VERTEX_ARRAY_BIT")
  (all-attrib-bits "GL_CLIENT_ALL_ATTRIB_BITS"))

(define-gl-enum gl-polygon-offset
  (factor "GL_POLYGON_OFFSET_FACTOR")
  (units "GL_POLYGON_OFFSET_UNITS")
  (point "GL_POLYGON_OFFSET_POINT")
  (line "GL_POLYGON_OFFSET_LINE")
  (fill "GL_POLYGON_OFFSET_FILL"))

(define-gl-enum gl-texture
  (alpha4 "GL_ALPHA4")
  (alpha8 "GL_ALPHA8")
  (alpha12 "GL_ALPHA12")
  (alpha16 "GL_ALPHA16")
  (luminance4 "GL_LUMINANCE4")
  (luminance8 "GL_LUMINANCE8")
  (luminance12 "GL_LUMINANCE12")
  (luminance16 "GL_LUMINANCE16")
  (luminance4-alpha4 "GL_LUMINANCE4_ALPHA4")
  (luminance6-alpha2 "GL_LUMINANCE6_ALPHA2")
  (luminance8-alpha8 "GL_LUMINANCE8_ALPHA8")
  (luminance12-alpha4 "GL_LUMINANCE12_ALPHA4")
  (luminance12-alpha12 "GL_LUMINANCE12_ALPHA12")
  (luminance16-alpha16 "GL_LUMINANCE16_ALPHA16")
  (intensity "GL_INTENSITY")
  (intensity4 "GL_INTENSITY4")
  (intensity8 "GL_INTENSITY8")
  (intensity12 "GL_INTENSITY12")
  (intensity16 "GL_INTENSITY16")
  (r3-g3-b2 "GL_R3_G3_B2")
  (rgb4 "GL_RGB4")
  (rgb5 "GL_RGB5")
  (rgb8 "GL_RGB8")
  (rgb10 "GL_RGB10")
  (rgb12 "GL_RGB12")
  (rgb16 "GL_RGB16")
  (rgba2 "GL_RGBA2")
  (rgba4 "GL_RGBA4")
  (rgb5-a1 "GL_RGB5_A1")
  (rgba8 "GL_RGBA8")
  (rgb10-a2 "GL_RGB10_A2")
  (rgba12 "GL_RGBA12")
  (rgba16 "GL_RGBA16")
  (texture-red-size "GL_TEXTURE_RED_SIZE")
  (texture-green-size "GL_TEXTURE_GREEN_SIZE")
  (texture-blue-size "GL_TEXTURE_BLUE_SIZE")
  (texture-alpha-size "GL_TEXTURE_ALPHA_SIZE")
  (texture-luminance-size "GL_TEXTURE_LUMINANCE_SIZE")
  (texture-intensity-size "GL_TEXTURE_INTENSITY_SIZE")
  (proxy-texture-1d "GL_PROXY_TEXTURE_1D")
  (proxy-texture-2d "GL_PROXY_TEXTURE_2D"))

(define-gl-enum gl-texture-object
  (priority "GL_TEXTURE_PRIORITY")
  (resident "GL_TEXTURE_RESIDENT")
  (binding-1d "GL_TEXTURE_BINDING_1D")
  (binding-2d "GL_TEXTURE_BINDING_2D")
  (binding-3d "GL_TEXTURE_BINDING_3D"))

(define-gl-enum gl-vertex-array 
  (vertex-array "GL_VERTEX_ARRAY")
  (normal-array "GL_NORMAL_ARRAY")
  (color-array "GL_COLOR_ARRAY")
  (index-array "GL_INDEX_ARRAY")
  (texture-coord-array "GL_TEXTURE_COORD_ARRAY")
  (edge-flag-array "GL_EDGE_FLAG_ARRAY")
  (vertex-array-size "GL_VERTEX_ARRAY_SIZE")
  (vertex-array-type "GL_VERTEX_ARRAY_TYPE")
  (vertex-array-stride "GL_VERTEX_ARRAY_STRIDE")
  (normal-array-type "GL_NORMAL_ARRAY_TYPE")
  (normal-array-stride "GL_NORMAL_ARRAY_STRIDE")
  (color-array-size "GL_COLOR_ARRAY_SIZE")
  (color-array-type "GL_COLOR_ARRAY_TYPE")
  (color-array-stride "GL_COLOR_ARRAY_STRIDE")
  (index-array-type "GL_INDEX_ARRAY_TYPE")
  (index-array-stride "GL_INDEX_ARRAY_STRIDE")
  (texture-coord-array-size "GL_TEXTURE_COORD_ARRAY_SIZE")
  (texture-coord-array-type "GL_TEXTURE_COORD_ARRAY_TYPE")
  (texture-coord-array-stride "GL_TEXTURE_COORD_ARRAY_STRIDE")
  (edge-flag-array-stride "GL_EDGE_FLAG_ARRAY_STRIDE")
  (vertex-array-pointer "GL_VERTEX_ARRAY_POINTER")
  (normal-array-pointer "GL_NORMAL_ARRAY_POINTER")
  (color-array-pointer "GL_COLOR_ARRAY_POINTER")
  (index-array-pointer "GL_INDEX_ARRAY_POINTER")
  (texture-coord-array-pointer "GL_TEXTURE_COORD_ARRAY_POINTER")
  (edge-flag-array-pointer "GL_EDGE_FLAG_ARRAY_POINTER")
  (v2f "GL_V2F")
  (v3f "GL_V3F")
  (c4ub-v2f "GL_C4UB_V2F")
  (c4ub-v3f "GL_C4UB_V3F")
  (c3f-v3f "GL_C3F_V3F")
  (n3f-v3f "GL_N3F_V3F")
  (c4f-n3f-v3f "GL_C4F_N3F_V3F")
  (t2f-v3f "GL_T2F_V3F")
  (t4f-v4f "GL_T4F_V4F")
  (t2f-c4ub-v3f "GL_T2F_C4UB_V3F")
  (t2f-c3f-v3f "GL_T2F_C3F_V3F")
  (t2f-n3f-v3f "GL_T2F_N3F_V3F")
  (t2f-c4f-n3f-v3f "GL_T2F_C4F_N3F_V3F")
  (t4f-c4f-n3f-v4f "GL_T4F_C4F_N3F_V4F"))

(define-gl-enum gl-bgra
  (bgr "GL_BGR")
  (bgra "GL_BGRA"))

(define-gl-enum gl-blend-color
  (constant-color "GL_CONSTANT_COLOR")
  (one-minus-constant-color "GL_ONE_MINUS_CONSTANT_COLOR")
  (constant-alpha "GL_CONSTANT_ALPHA")
  (one-minus-constant-alpha "GL_ONE_MINUS_CONSTANT_ALPHA")
  (blend-color "GL_BLEND_COLOR"))

(define-gl-enum gl-blend-minmax
  (func-add "GL_FUNC_ADD")
  (min "GL_MIN")
  (max "GL_MAX")
  (blend-equation "GL_BLEND_EQUATION"))

(define-gl-enum gl-blend-equation-separate
  (rgb "GL_BLEND_EQUATION_RGB")
  (alpha "GL_BLEND_EQUATION_ALPHA"))

(define-gl-enum gl-blend-subtract 
  (- "GL_FUNC_SUBTRACT")
  (rev- "GL_FUNC_REVERSE_SUBTRACT"))

(define-gl-enum gl-color-matrix 
  (standard "GL_COLOR_MATRIX")
  (stack-depth "GL_COLOR_MATRIX_STACK_DEPTH")
  (max-stack-depth "GL_MAX_COLOR_MATRIX_STACK_DEPTH")
  (post-red-scale "GL_POST_COLOR_MATRIX_RED_SCALE")
  (post-green-scale "GL_POST_COLOR_MATRIX_GREEN_SCALE")
  (post-blue-scale "GL_POST_COLOR_MATRIX_BLUE_SCALE")
  (post-alpha-scale "GL_POST_COLOR_MATRIX_ALPHA_SCALE")
  (post-red-bias "GL_POST_COLOR_MATRIX_RED_BIAS")
  (post-green-bias "GL_POST_COLOR_MATRIX_GREEN_BIAS")
  (post-blue-bias "GL_POST_COLOR_MATRIX_BLUE_BIAS")
  (post-alpha-bias "GL_POST_COLOR_MATRIX_ALPHA_BIAS"))

(define-gl-enum gl-color-table 
  (standard "GL_COLOR_TABLE")
  (post-convolution "GL_POST_CONVOLUTION_COLOR_TABLE")
  (post-color-matrix "GL_POST_COLOR_MATRIX_COLOR_TABLE")
  (proxy "GL_PROXY_COLOR_TABLE")
  (proxy-post-convolution "GL_PROXY_POST_CONVOLUTION_COLOR_TABLE")
  (proxy-post-color-matrix "GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE")
  (scale "GL_COLOR_TABLE_SCALE")
  (bias "GL_COLOR_TABLE_BIAS")
  (format "GL_COLOR_TABLE_FORMAT")
  (width "GL_COLOR_TABLE_WIDTH")
  (red-size "GL_COLOR_TABLE_RED_SIZE")
  (green-size "GL_COLOR_TABLE_GREEN_SIZE")
  (blue-size "GL_COLOR_TABLE_BLUE_SIZE")
  (alpha-size "GL_COLOR_TABLE_ALPHA_SIZE")
  (luminance-size "GL_COLOR_TABLE_LUMINANCE_SIZE")
  (intensity-size "GL_COLOR_TABLE_INTENSITY_SIZE"))

(define-gl-enum gl-convolution
  (convolution-1d "GL_CONVOLUTION_1D")
  (convolution-2d "GL_CONVOLUTION_2D")
  (separable-2d "GL_SEPARABLE_2D")
  (convolution-border-mode "GL_CONVOLUTION_BORDER_MODE")
  (convolution-filter-scale "GL_CONVOLUTION_FILTER_SCALE")
  (convolution-filter-bias "GL_CONVOLUTION_FILTER_BIAS")
  (reduce "GL_REDUCE")
  (convolution-format "GL_CONVOLUTION_FORMAT")
  (convolution-width "GL_CONVOLUTION_WIDTH")
  (convolution-height "GL_CONVOLUTION_HEIGHT")
  (max-convolution-width "GL_MAX_CONVOLUTION_WIDTH")
  (max-convolution-height "GL_MAX_CONVOLUTION_HEIGHT")
  (post-convolution-red-scale "GL_POST_CONVOLUTION_RED_SCALE")
  (post-convolution-green-scale "GL_POST_CONVOLUTION_GREEN_SCALE")
  (post-convolution-blue-scale "GL_POST_CONVOLUTION_BLUE_SCALE")
  (post-convolution-alpha-scale "GL_POST_CONVOLUTION_ALPHA_SCALE")
  (post-convolution-red-bias "GL_POST_CONVOLUTION_RED_BIAS")
  (post-convolution-green-bias "GL_POST_CONVOLUTION_GREEN_BIAS")
  (post-convolution-blue-bias "GL_POST_CONVOLUTION_BLUE_BIAS")
  (post-convolution-alpha-bias "GL_POST_CONVOLUTION_ALPHA_BIAS")
  (constant-border "GL_CONSTANT_BORDER")
  (replicate-border "GL_REPLICATE_BORDER")
  (convolution-border-color "GL_CONVOLUTION_BORDER_COLOR"))

(define-gl-enum gl-draw-range-elements
  (max-elements-vertices "GL_MAX_ELEMENTS_VERTICES")
  (max-elements-indices "GL_MAX_ELEMENTS_INDICES"))

(define-gl-enum gl-histogram
  (histogram "GL_HISTOGRAM")
  (proxy-histogram "GL_PROXY_HISTOGRAM")
  (histogram-width "GL_HISTOGRAM_WIDTH")
  (histogram-format "GL_HISTOGRAM_FORMAT")
  (histogram-red-size "GL_HISTOGRAM_RED_SIZE")
  (histogram-green-size "GL_HISTOGRAM_GREEN_SIZE")
  (histogram-blue-size "GL_HISTOGRAM_BLUE_SIZE")
  (histogram-alpha-size "GL_HISTOGRAM_ALPHA_SIZE")
  (histogram-luminance-size "GL_HISTOGRAM_LUMINANCE_SIZE")
  (histogram-sink "GL_HISTOGRAM_SINK")
  (minmax "GL_MINMAX")
  (minmax-format "GL_MINMAX_FORMAT")
  (minmax-sink "GL_MINMAX_SINK")
  (table-too-large "GL_TABLE_TOO_LARGE"))

(define-gl-enum gl-packed-pixels
  (ubyte-3-3-2 "GL_UNSIGNED_BYTE_3_3_2")
  (ushort-4-4-4-4 "GL_UNSIGNED_SHORT_4_4_4_4")
  (ushort-5-5-5-1 "GL_UNSIGNED_SHORT_5_5_5_1")
  (uint-8-8-8-8 "GL_UNSIGNED_INT_8_8_8_8")
  (uint-10-10-10-2 "GL_UNSIGNED_INT_10_10_10_2")
  (ubyte-2-3-3-rev "GL_UNSIGNED_BYTE_2_3_3_REV")
  (ushort-5-6-5 "GL_UNSIGNED_SHORT_5_6_5")
  (ushort-5-6-5-rev "GL_UNSIGNED_SHORT_5_6_5_REV")
  (ushort-4-4-4-4-rev "GL_UNSIGNED_SHORT_4_4_4_4_REV")
  (ushort-1-5-5-5-rev "GL_UNSIGNED_SHORT_1_5_5_5_REV")
  (uint-8-8-8-8-rev "GL_UNSIGNED_INT_8_8_8_8_REV")
  (uint-2-10-10-10-rev "GL_UNSIGNED_INT_2_10_10_10_REV"))

(define-gl-enum gl-rescale-normal
  (rescale-normal "GL_RESCALE_NORMAL"))

(define-gl-enum gl-separate-specular-color
  (light-model-color-control "GL_LIGHT_MODEL_COLOR_CONTROL")
  (single-color "GL_SINGLE_COLOR")
  (separate-specular-color "GL_SEPARATE_SPECULAR_COLOR"))

(define-gl-enum gl-texture3d
  (pack-skip-images "GL_PACK_SKIP_IMAGES")
  (pack-image-height "GL_PACK_IMAGE_HEIGHT")
  (unpack-skip-images "GL_UNPACK_SKIP_IMAGES")
  (unpack-image-height "GL_UNPACK_IMAGE_HEIGHT")
  (texture-3d "GL_TEXTURE_3D")
  (proxy-texture-3d "GL_PROXY_TEXTURE_3D")
  (texture-depth "GL_TEXTURE_DEPTH")
  (texture-wrap-r "GL_TEXTURE_WRAP_R")
  (max-3d-texture-size "GL_MAX_3D_TEXTURE_SIZE"))

(define-gl-enum gl-texture-edge-clamp
  (->edge "GL_CLAMP_TO_EDGE")
  (->border "GL_CLAMP_TO_BORDER"))

(define-gl-enum gl-texture-lod
  (min-lod "GL_TEXTURE_MIN_LOD")
  (max-lod "GL_TEXTURE_MAX_LOD")
  (base-level "GL_TEXTURE_BASE_LEVEL")
  (max-level "GL_TEXTURE_MAX_LEVEL"))

;;; /* GetTarget1_2 */
(define-gl-enum gl-target1-2
  (smooth-point-size-range "GL_SMOOTH_POINT_SIZE_RANGE")
  (smooth-point-size-granularity "GL_SMOOTH_POINT_SIZE_GRANULARITY")
  (smooth-line-width-range "GL_SMOOTH_LINE_WIDTH_RANGE")
  (smooth-line-width-granularity "GL_SMOOTH_LINE_WIDTH_GRANULARITY")
  (aliased-point-size-range "GL_ALIASED_POINT_SIZE_RANGE")
  (aliased-line-width-range "GL_ALIASED_LINE_WIDTH_RANGE")

  (texture0 "GL_TEXTURE0")
  (texture1 "GL_TEXTURE1")
  (texture2 "GL_TEXTURE2")
  (texture3 "GL_TEXTURE3")
  (texture4 "GL_TEXTURE4")
  (texture5 "GL_TEXTURE5")
  (texture6 "GL_TEXTURE6")
  (texture7 "GL_TEXTURE7")
  (texture8 "GL_TEXTURE8")
  (texture9 "GL_TEXTURE9")
  (texture10 "GL_TEXTURE10")
  (texture11 "GL_TEXTURE11")
  (texture12 "GL_TEXTURE12")
  (texture13 "GL_TEXTURE13")
  (texture14 "GL_TEXTURE14")
  (texture15 "GL_TEXTURE15")
  (texture16 "GL_TEXTURE16")
  (texture17 "GL_TEXTURE17")
  (texture18 "GL_TEXTURE18")
  (texture19 "GL_TEXTURE19")
  (texture20 "GL_TEXTURE20")
  (texture21 "GL_TEXTURE21")
  (texture22 "GL_TEXTURE22")
  (texture23 "GL_TEXTURE23")
  (texture24 "GL_TEXTURE24")
  (texture25 "GL_TEXTURE25")
  (texture26 "GL_TEXTURE26")
  (texture27 "GL_TEXTURE27")
  (texture28 "GL_TEXTURE28")
  (texture29 "GL_TEXTURE29")
  (texture30 "GL_TEXTURE30")
  (texture31 "GL_TEXTURE31")
  (active-texture "GL_ACTIVE_TEXTURE")
  (client-active-texture "GL_CLIENT_ACTIVE_TEXTURE")
  (max-texture-units "GL_MAX_TEXTURE_UNITS")

  (combine "GL_COMBINE")
  (combine-rgb "GL_COMBINE_RGB")
  (combine-alpha "GL_COMBINE_ALPHA")
  (rgb-scale "GL_RGB_SCALE")
  (add-signed "GL_ADD_SIGNED")
  (interpolate "GL_INTERPOLATE")
  (constant "GL_CONSTANT")
  (primary-color "GL_PRIMARY_COLOR")
  (previous "GL_PREVIOUS")
  (subtract "GL_SUBTRACT")

  (src0-rgb "GL_SRC0_RGB")
  (src1-rgb "GL_SRC1_RGB")
  (src2-rgb "GL_SRC2_RGB")
  (src3-rgb "GL_SRC3_RGB")
  (src4-rgb "GL_SRC4_RGB")
  (src5-rgb "GL_SRC5_RGB")
  (src6-rgb "GL_SRC6_RGB")
  (src7-rgb "GL_SRC7_RGB")
  (src0-alpha "GL_SRC0_ALPHA")
  (src1-alpha "GL_SRC1_ALPHA")
  (src2-alpha "GL_SRC2_ALPHA")
  (src3-alpha "GL_SRC3_ALPHA")
  (src4-alpha "GL_SRC4_ALPHA")
  (src5-alpha "GL_SRC5_ALPHA")
  (src6-alpha "GL_SRC6_ALPHA")
  (src7-alpha "GL_SRC7_ALPHA"))

(define-gl-enum gl-occlusion-query
  (query-counter-bits "GL_QUERY_COUNTER_BITS")
  (current-query "GL_CURRENT_QUERY")
  (query-result "GL_QUERY_RESULT")
  (query-result-available "GL_QUERY_RESULT_AVAILABLE")
  (samples-passed "GL_SAMPLES_PASSED")

  (fog-coord-src "GL_FOG_COORD_SRC")
  (fog-coord "GL_FOG_COORD")
  (fragment-depth "GL_FRAGMENT_DEPTH")
  (current-fog-coord "GL_CURRENT_FOG_COORD")
  (fog-coord-array-type "GL_FOG_COORD_ARRAY_TYPE")
  (fog-coord-array-stride "GL_FOG_COORD_ARRAY_STRIDE")
  (fog-coord-array-pointer "GL_FOG_COORD_ARRAY_POINTER")
  (fog-coord-array "GL_FOG_COORD_ARRAY"))

;;; /* vertex_buffer_object */
(define-gl-enum gl-vertex-buffer-object
  (array-buffer "GL_ARRAY_BUFFER")
  (element-array-buffer "GL_ELEMENT_ARRAY_BUFFER")
  (array-buffer-binding "GL_ARRAY_BUFFER_BINDING")
  (element-array-buffer-binding "GL_ELEMENT_ARRAY_BUFFER_BINDING")
  (vertex-array-buffer-binding "GL_VERTEX_ARRAY_BUFFER_BINDING")
  (normal-array-buffer-binding "GL_NORMAL_ARRAY_BUFFER_BINDING")
  (color-array-buffer-binding "GL_COLOR_ARRAY_BUFFER_BINDING")
  (index-array-buffer-binding "GL_INDEX_ARRAY_BUFFER_BINDING")
  (texture-coord-array-buffer-binding "GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING")
  (edge-flag-array-buffer-binding "GL_EDGE_FLAG_ARRAY_BUFFER_BINDING")
  (secondary-color-array-buffer-binding "GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING")
  (fog-coord-array-buffer-binding "GL_FOG_COORD_ARRAY_BUFFER_BINDING")
  (weight-array-buffer-binding "GL_WEIGHT_ARRAY_BUFFER_BINDING")
  (vertex-attrib-array-buffer-binding "GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING")
  (stream-draw "GL_STREAM_DRAW")
  (stream-read "GL_STREAM_READ")
  (stream-copy "GL_STREAM_COPY")
  (static-draw "GL_STATIC_DRAW")
  (static-read "GL_STATIC_READ")
  (static-copy "GL_STATIC_COPY")
  (dynamic-draw "GL_DYNAMIC_DRAW")
  (dynamic-read "GL_DYNAMIC_READ")
  (dynamic-copy "GL_DYNAMIC_COPY")
  (read-only "GL_READ_ONLY")
  (write-only "GL_WRITE_ONLY")
  (read-write "GL_READ_WRITE")
  (buffer-size "GL_BUFFER_SIZE")
  (buffer-usage "GL_BUFFER_USAGE")
  (buffer-access "GL_BUFFER_ACCESS")
  (buffer-mapped "GL_BUFFER_MAPPED")
  (buffer-map-pointer "GL_BUFFER_MAP_POINTER"))

(define-gl-enum gl-draw-elements-type
  (ubyte  "GL_UNSIGNED_BYTE")
  (ushort "GL_UNSIGNED_SHORT")
  (uint   "GL_UNSIGNED_INT"))
