(require 'std-ffi)
(require 'foreign-stdlib)
(require 'foreign-sugar)
(require 'foreign-ctools)
(require 'foreign-cenums)
(require 'srfi-0)
(require 'glib) ;; convenience; who's going to use gtk without glib?
(require 'gdk)
(require 'gtk-helper-syntax)
(require 'gtk-enums)

(let ((os (assq 'os-name (system-features))))
  (cond 
   ((equal? os '(os-name . "Linux"))
    (foreign-file "/usr/lib/libgtk-x11-2.0.so.0"))    
   ((equal? os '(os-name . "SunOS"))
    (foreign-file "/usr/lib/libgtk-x11-2.0.so"))
   ((equal? os '(os-name . "MacOS X"))
    (foreign-file "/sw/lib/libgtk-x11-2.0.dylib")
    ;(foreign-file "~/Library/Gtk+-Cocoa.framework/Gtk+-Cocoa")
    )
   (else
    (error "Add case in gtk.sch for os: " os))))

;;; XXX perhaps we need a bit of type abstraction for callbacks
;;; like these, where we could abstract over what type should be
;;; ascribed to the callback argument.
;;;
;;; (But that's an absurd amount of machinery to add when one can
;;; easily get around the problem by passing closures as the callback,
;;; as would have been appropriate in the first place)

(define gtktextiter*-rt (ffi-install-void*-subtype 'gtktextiter*))
(establish-void*-subhierarchy! '(gtkclipboard*))
(establish-void*-subhierarchy! '(gtktextchildanchor*))
(establish-void*-subhierarchy! '(gtkwindowgroup*))
(establish-void*-subhierarchy! '(gtkiconset*))

(establish-void*-subhierarchy!
 '(gobject* (gtkobject* 
             (gtkwidget* (gtkentry*)
                         (gtkinvisible*)
                         (gtkcontainer*
                          (gtkbin* (gtkalignment*)
                                   (gtkwindow* (gtkdialog* (gtkaboutdialog*)
                                                           (gtkmessagedialog*)
                                                           (gtkfileselection*)))
                                   (gtkbutton* (gtktogglebutton*
                                                (gtkcheckbutton*
                                                 (gtkradiobutton*)))
                                               (gtkoptionmenu*))
                                   (gtkcombobox*)
                                   (gtktoolitem* (gtktoolbutton*))
                                   (gtkframe*)
                                   (gtkitem* (gtkmenuitem*
                                              (gtkcheckmenuitem*
                                               (gtkradiomenuitem*))
                                              (gtkimagemenuitem*)
                                              (gtkseparatormenuitem*)
                                              (gtktearoffmenuitem*))))
                          (gtkbox* (gtkvbox*)
                                   (gtkhbox*
                                    (gtkstatusbar*)
                                    (gtkcombo*)))
                          (gtktable*)
                          (gtktoolbar*)
                          (gtkmenushell* (gtkmenubar*)
                                         (gtkmenu*))
                          (gtktextview*)) ;; end gtkcontainer*
                         (gtkmisc* (gtklabel* (gtkaccellabel*))
                                   (gtkarrow*)
                                   (gtkimage*)
                                   (gtkpixmap*))
                         (gtkrange* (gtkscale*)
                                    (gtkscrollbar*))
                         (gtkprogress* (gtkprogressbar*))
;; Deprecated in gtk2
;                         (gtktext*)
                         )
             (gtktooltips*)
             (gtkadjustment*))
            (gtkaccelgroup*)
            (gtktextbuffer*)
            (gtktextmark*)
            (gtktexttagtable*)
            (gtktexttag*)
            (gtkentrycompletion*)
            ))

(define *gtk-init-invoked* #f)
(define gtk-init 
  (let ()
    (define-foreign (gtk-init void* void*) void)
    (lambda arg-strings
      (let ((string-vec (list->vector (cons "larceny" arg-strings))))
        (call-with-char** string-vec
                          (lambda (argv)
                            (call-with-boxed 
                             argv 
                             (lambda (&argv)
                               (call-with-boxed (vector-length string-vec)
                                                (lambda (&argc)
                                                  (gtk-init &argc &argv)
                                                  (set! *gtk-init-invoked* #t)
                                                  ))))))))))
(define (implicit-gtk-init)
  (cond ((not *gtk-init-invoked*) 
         (gtk-init))))

(define-syntax define-gtk-foreign
  (syntax-rules ()
    ((_ (NAME ARGS ...) RET)
     (define NAME 
       (let ()
         (define-foreign (NAME ARGS ...) RET)
         (lambda argl
           (implicit-gtk-init)
           (apply NAME argl)))))))

(define-gtk-foreign (gtk-widget-show gtkwidget*) void)
(define-gtk-foreign (gtk-widget-show-now gtkwidget*) void)
(define-gtk-foreign (gtk-widget-hide gtkwidget*) void)
(define-gtk-foreign (gtk-widget-show-all gtkwidget*) void)
(define-gtk-foreign (gtk-widget-hide-all gtkwidget*) void)
(define-gtk-foreign (gtk-widget-map gtkwidget*) void)
(define-gtk-foreign (gtk-widget-unmap gtkwidget*) void)
(define-gtk-foreign (gtk-widget-realize gtkwidget*) void)
(define-gtk-foreign (gtk-widget-unrealize gtkwidget*) void)
(define-gtk-foreign (gtk-widget-add-accelerator gtkwidget* 
                                                string gtkaccelgroup* 
                                                char
                                                gdkmodifiertype 
                                                gtkaccelgroup)
  void)
(define-gtk-foreign (gtk-widget-get-parent gtkwidget*) gtkwidget*)
(define-gtk-foreign (gtk-widget-set-parent gtkwidget* gtkwidget*) void)
(define-gtk-foreign (gtk-widget-get-parent-window gtkwidget*) gdkwindow*)
(define-gtk-foreign (gtk-widget-set-parent-window gtkwidget* gdkwindow*) void)
(define-gtk-foreign (gtk-widget-grab-default gtkwidget*) void)
(define-gtk-foreign (gtk-widget-grab-focus gtkwidget*) void)
(define-gtk-foreign (gtk-grab-add gtkwidget*) void)
(define-gtk-foreign (gtk-grab-get-current) gtkwidget*)
(define-gtk-foreign (gtk-grab-remove gtkwidget*) void)
(define (gtk-widget-set-flags widget flags)
  (void*-word-set! widget gtkobject-flags-offset 
                   (fxlogior 
                    (void*-word-ref widget gtkobject-flags-offset)
                    ((ffi/arg-converter 'gtkwidgetflags)
                     flags))))

(define-gtk-foreign (gtk-main) void)
(define-gtk-foreign (gtk-main-level) uint)
(define-gtk-foreign (gtk-main-quit) void)
(define-gtk-foreign (gtk-main-iteration) bool)
(define-gtk-foreign (gtk-main-iteration-do bool) bool)
(define-gtk-foreign (gtk-timeout-add uint (-> (void*) bool) (maybe void*)) uint)
(define-gtk-foreign (gtk-timeout-remove uint) void)
(define-gtk-foreign (gtk-events-pending) bool)
(define-gtk-foreign (gtk-exit int) void)


(define-gtk-foreign (gtk-container-set-border-width! gtkcontainer* int) void)
(define-gtk-foreign (gtk-container-add gtkcontainer* gtkwidget*) void)

(define-gtk-foreign (gtk-hbox-new bool int) gtkhbox*)
(define-gtk-foreign (gtk-vbox-new bool int) gtkvbox*)
(define-gtk-foreign (gtk-hseparator-new) gtkwidget*)
(define-gtk-foreign (gtk-box-pack-start gtkbox* gtkwidget* bool bool int) void)
(define-gtk-foreign (gtk-box-pack-end   gtkbox* gtkwidget* bool bool int) void)
(define-gtk-foreign (gtk-misc-set-alignment gtkmisc* float float) void)
(define-gtk-foreign (gtk-misc-set-padding gtkmisc* int int) void)
(define-gtk-foreign (gtk-widget-set-size-request gtkwidget* int int) void)
(define-gtk-foreign (gtk-table-new int int bool) gtkwidget*)
(define-gtk-foreign (gtk-table-attach-defaults gtktable* gtkwidget* int int int int)
  void)
(define-gtk-foreign (gtk-table-set-row-spacing gtktable* uint uint) void)

(define-gtk-foreign (gtk-adjustment-new double double double double double double) gtkobject*)
(define-gtk-foreign (gtk-vscale-new gtkadjustment*) gtkwidget*)
(define-gtk-foreign (gtk-hscale-new gtkadjustment*) gtkwidget*)
(define-gtk-foreign (gtk-hscrollbar-new gtkadjustment*) gtkwidget*)
(define-gtk-foreign (gtk-vscrollbar-new gtkadjustment*) gtkwidget*)
(define-gtk-foreign (gtk-range-set-update-policy gtkrange* gtkupdatetype) void)
(define-gtk-foreign (gtk-scale-set-digits gtkscale* int) void)
(define-gtk-foreign (gtk-scale-set-value-pos gtkscale* gtkpositiontype) void)
(define-gtk-foreign (gtk-scale-set-draw-value gtkscale* bool) void)
(define-gtk-foreign (gtk-menu-item-new-with-label string) gtkmenuitem*)
(define-gtk-foreign (gtk-menu-item-new) gtkmenuitem*)
(define-gtk-foreign (gtk-menu-new) gtkmenu*)
(define-gtk-foreign (gtk-option-menu-new) gtkoptionmenu*)
(define-gtk-foreign (gtk-menu-shell-append gtkmenushell* gtkwidget*) void)
(define-gtk-foreign (gtk-option-menu-set-menu gtkoptionmenu* gtkwidget*) void)
(define-gtk-foreign (gtk-frame-new string) gtkframe*)
(define-gtk-foreign (gtk-frame-set-shadow-type gtkframe* gtkshadowtype) void)
(define-gtk-foreign (gtk-frame-get-shadow-type gtkframe*) gtkshadowtype)
(define-gtk-foreign (gtk-frame-set-label-align gtkframe* float float) void)
;; XXX need boxed floats to do get-frame-get-label-align...
(define-gtk-foreign (gtk-label-new string) gtkwidget*)
(define-gtk-foreign (gtk-label-set-text gtklabel* string) void)
(define-gtk-foreign (gtk-label-set-markup gtklabel* string) void)
(define-gtk-foreign (gtk-label-set-markup-with-mnemonic gtklabel* string) void)
(define-gtk-foreign (gtk-label-set-pattern gtklabel* string) void)
(define-gtk-foreign (gtk-label-set-justify gtklabel* gtkjustification) void)
(define-gtk-foreign (gtk-label-set-width-chars gtklabel* int) void)
(define-gtk-foreign (gtk-label-set-max-width-chars gtklabel* int) void)
(define-gtk-foreign (gtk-label-get gtklabel* (ret string)) void)
(define-gtk-foreign (gtk-label-parse-uline gtklabel* string) int)
(define-gtk-foreign (gtk-label-set-line-wrap gtklabel* bool) void)
(define-gtk-foreign (gtk-label-get-layout-offsets gtklabel* (ret int) (ret int)) void)
(define-gtk-foreign (gtk-label-get-mnemonic-keyval gtklabel*) uint)
(define-gtk-foreign (gtk-label-get-selectable gtklabel*) bool)
(define-gtk-foreign (gtk-label-get-text gtklabel*) string)
(define-gtk-foreign (gtk-label-new-with-mnemonic string) gtklabel*)
(define-gtk-foreign (gtk-label-select-region gtklabel* int int) void)
(define-gtk-foreign (gtk-label-set-mnemonic-widget gtklabel* gtkwidget*) void)
(define-gtk-foreign (gtk-label-set-selectable gtklabel* bool) void)
(define-gtk-foreign (gtk-label-set-text-with-mnemonic gtklabel* string) void)
(define-gtk-foreign (gtk-label-get-justify gtklabel*) gtkjustification)
(define-gtk-foreign (gtk-label-get-width-chars gtklabel*) int)
(define-gtk-foreign (gtk-label-get-max-width-chars gtklabel*) int)
(define-gtk-foreign (gtk-label-get-label gtklabel*) string)
(define-gtk-foreign (gtk-label-get-line-wrap gtklabel*) bool)
(define-gtk-foreign (gtk-label-get-mnemonic-widget gtklabel*) gtkwidget*)
(define-gtk-foreign (gtk-label-get-selection-bounds gtklabel* (ret int) (ret int)) bool)
(define-gtk-foreign (gtk-label-get-use-markup gtklabel*) bool)
(define-gtk-foreign (gtk-label-get-use-underline gtklabel*) bool)
(define-gtk-foreign (gtk-label-get-single-line-mode gtklabel*) bool)
(define-gtk-foreign (gtk-label-get-angle gtklabel*) double)
(define-gtk-foreign (gtk-label-set-label gtklabel* string) void)
(define-gtk-foreign (gtk-label-set-use-markup gtklabel* bool) void)
(define-gtk-foreign (gtk-label-set-use-underline gtklabel* bool) void)
(define-gtk-foreign (gtk-label-set-single-line-mode gtklabel* bool) void)
(define-gtk-foreign (gtk-label-set-angle gtklabel* double) void)

(define-gtk-foreign (gtk-widget-show-all gtkwidget*) void)
(define-gtk-foreign (gtk-arrow-new gtkarrowtype gtkshadowtype) gtkarrow*)
(define-gtk-foreign (gtk-alignment-new float float float float) gtkalignment*)
(define-gtk-foreign (gtk-table-attach gtktable* gtkwidget* 
                                  uint uint uint uint 
                                  gtkattachoptions gtkattachoptions
                                  uint uint) 
  void)
(define-gtk-foreign (gtk-widget-destroy gtkwidget*) void)
(define-gtk-foreign (gtk-progress-bar-new) gtkprogressbar*)
(define-gtk-foreign (gtk-progress-bar-pulse gtkprogressbar*) void)
(define-gtk-foreign (gtk-progress-bar-set-text gtkprogressbar* string) void)
(define-gtk-foreign (gtk-progress-bar-set-fraction gtkprogressbar* double) void)
(define-gtk-foreign (gtk-progress-bar-set-pulse-step gtkprogressbar* double) void)
(define-gtk-foreign (gtk-progress-bar-set-orientation gtkprogressbar* gtkprogressbarorientation) void)
(define-gtk-foreign (gtk-progress-bar-get-text gtkprogressbar*) string)
(define-gtk-foreign (gtk-progress-bar-get-fraction gtkprogressbar*) double)
(define-gtk-foreign (gtk-progress-bar-get-pulse-step gtkprogressbar*) double)
(define-gtk-foreign (gtk-progress-bar-get-orientation gtkprogressbar*) gtkprogressbarorientation)
(define-gtk-foreign (gtk-progress-bar-new-with-adjustment gtkadjustment*) gtkprogressbar*)
(define-gtk-foreign (gtk-progress-bar-set-bar-style gtkprogressbar* gtkprogressbarstyle) void)
(define-gtk-foreign (gtk-progress-bar-set-discrete-blocks gtkprogressbar* uint) void)
(define-gtk-foreign (gtk-progress-bar-set-activity-step gtkprogressbar* uint) void)
(define-gtk-foreign (gtk-progress-bar-set-activity-blocks gtkprogressbar* uint) void)
(define-gtk-foreign (gtk-progress-bar-update gtkprogressbar* double) void)

(define-gtk-foreign (gtk-statusbar-new) gtkstatusbar*)
(define-gtk-foreign (gtk-statusbar-get-context-id gtkstatusbar* string) uint)
(define-gtk-foreign (gtk-statusbar-push gtkstatusbar* uint string) uint)
(define-gtk-foreign (gtk-statusbar-pop gtkstatusbar* uint) void)
(define-gtk-foreign (gtk-statusbar-remove gtkstatusbar* uint uint) void)
(define-gtk-foreign (gtk-statusbar-set-has-resize-grip gtkstatusbar* bool) void)
(define-gtk-foreign (gtk-statusbar-get-has-resize-grip gtkstatusbar*) bool)

(define-gtk-foreign (gtk-button-new) gtkbutton*)
(define-gtk-foreign (gtk-button-new-with-label string) gtkbutton*)
(define-gtk-foreign (gtk-button-new-with-mnemonic string) gtkbutton*)
(define-gtk-foreign (gtk-button-new-from-stock string) gtkbutton*)
(define-gtk-foreign (gtk-button-pressed gtkbutton*) void)
(define-gtk-foreign (gtk-button-released gtkbutton*) void)
(define-gtk-foreign (gtk-button-clicked gtkbutton*) void)
(define-gtk-foreign (gtk-button-enter gtkbutton*) void)
(define-gtk-foreign (gtk-button-leave gtkbutton*) void)
(define-gtk-foreign (gtk-button-set-relief gtkbutton* gtkreliefstyle) void)
(define-gtk-foreign (gtk-button-get-relief gtkbutton*) gtkreliefstyle)
(define-gtk-foreign (gtk-button-get-label gtkbutton*) string)
(define-gtk-foreign (gtk-button-set-label gtkbutton* string) void)
(define-gtk-foreign (gtk-button-get-use-stock gtkbutton*) bool)
(define-gtk-foreign (gtk-button-set-use-stock gtkbutton* bool) void)
(define-gtk-foreign (gtk-button-get-use-underline gtkbutton*) bool)
(define-gtk-foreign (gtk-button-set-use-underline gtkbutton* bool) void)
(define-gtk-foreign (gtk-button-set-focus-on-click gtkbutton* bool) void)
(define-gtk-foreign (gtk-button-get-focus-on-click gtkbutton*) bool)
(define-gtk-foreign (gtk-button-set-alignment gtkbutton* float float) void)
;XXX (define-gtk-foreign (gtk-button-get-alignment gtkbutton* (ret float) (ret float)) void)

(define-gtk-foreign (gtk-check-button-new) gtkcheckbutton*)
(define-gtk-foreign (gtk-check-button-new-with-label string) gtkcheckbutton*)
(define-gtk-foreign (gtk-check-button-new-with-mnemonic string) gtkcheckbutton*)

;(define-gtk-foreign (gtk-radio-button-new gslist*) gtkradiobutton*)
(define-gtk-foreign (gtk-radio-button-new-from-widget gtkradiobutton*) 
  gtkradiobutton*)
(define-gtk-foreign (gtk-radio-button-new-with-label (maybe void*) string) 
  gtkradiobutton*)
(define-gtk-foreign (gtk-radio-button-new-with-label-from-widget 
                 gtkradiobutton* string) gtkradiobutton*)
;(define-gtk-foreign (gtk-radio-button-new-with-mnemonic gslist* string) gtkradiobutton*)
(define-gtk-foreign (gtk-radio-button-new-with-mnemonic-from-widget 
                 gtkradiobutton* string) gtkradiobutton*)
;(define-gtk-foreign (gtk-radio-button-set-group gtkradiobutton* gslist*) void)
;(define-gtk-foreign (gtk-radio-button-get-group gtkradiobutton*) gslist*)

(define-gtk-foreign (gtk-toggle-button-new) gtktogglebutton*)
(define-gtk-foreign (gtk-toggle-button-new-with-label string) gtktogglebutton*)
(define-gtk-foreign (gtk-toggle-button-new-with-mnemonic string) gtktogglebutton*)
(define-gtk-foreign (gtk-toggle-button-set-mode gtktogglebutton* bool) void)
(define-gtk-foreign (gtk-toggle-button-get-mode gtktogglebutton*) bool)
(define-gtk-foreign (gtk-toggle-button-toggled gtktogglebutton*) void)
(define-gtk-foreign (gtk-toggle-button-get-active gtktogglebutton*) bool)
(define-gtk-foreign (gtk-toggle-button-set-active gtktogglebutton* bool) void)
(define-gtk-foreign (gtk-toggle-button-set-inconsistent gtktogglebutton* bool) void)
(define-gtk-foreign (gtk-toggle-button-get-inconsistent gtktogglebutton*) bool)

(define-gtk-foreign (gtk-entry-new) gtkentry*)
(define-gtk-foreign (gtk-entry-new-with-max-length int) gtkentry*)
(define-gtk-foreign (gtk-entry-set-text gtkentry* string) void)
(define-gtk-foreign (gtk-entry-append-text gtkentry* string) void)
(define-gtk-foreign (gtk-entry-prepend-text gtkentry* string) void)
(define-gtk-foreign (gtk-entry-set-position gtkentry* int) void)
(define-gtk-foreign (gtk-entry-get-text gtkentry*) string)
(define-gtk-foreign (gtk-entry-select-region gtkentry* int int) void)
(define-gtk-foreign (gtk-entry-set-visibility gtkentry* bool) void)
(define-gtk-foreign (gtk-entry-set-invisible-char gtkentry* uint) void)
(define-gtk-foreign (gtk-entry-set-editable gtkentry* bool) void)
(define-gtk-foreign (gtk-entry-set-max-length gtkentry* int) void)
(define-gtk-foreign (gtk-entry-get-activates-default gtkentry*) bool)
(define-gtk-foreign (gtk-entry-get-has-frame gtkentry*) bool)
(define-gtk-foreign (gtk-entry-get-width-chars gtkentry*) int)
(define-gtk-foreign (gtk-entry-set-activates-default gtkentry* bool) void)
(define-gtk-foreign (gtk-entry-set-has-frame gtkentry* bool) void)
(define-gtk-foreign (gtk-entry-set-width-chars gtkentry* int) void)
(define-gtk-foreign (gtk-entry-get-invisible-char gtkentry*) uint)
(define-gtk-foreign (gtk-entry-set-alignment gtkentry* float) void)
(define-gtk-foreign (gtk-entry-get-alignment gtkentry*) float)
;(define-gtk-foreign (gtk-entry-get-layout gtkentry*) pangolayout*)
(define-gtk-foreign (gtk-entry-get-layout-offsets gtkentry* (ret int) (ret int)) void)
(define-gtk-foreign (gtk-entry-layout-index-to-text-index gtkentry* int) int)
(define-gtk-foreign (gtk-entry-text-index-to-layout-index gtkentry* int) int)
(define-gtk-foreign (gtk-entry-get-max-length gtkentry*) int)
(define-gtk-foreign (gtk-entry-get-visibility gtkentry*) bool)
(define-gtk-foreign (gtk-entry-set-completion gtkentry* gtkentrycompletion*) void)
(define-gtk-foreign (gtk-entry-get-completion gtkentry*) gtkentrycompletion*)

(define-gtk-foreign (gtk-container-set-border-width gtkcontainer* uint) void)
(define-gtk-foreign (gtk-container-get-border-width gtkcontainer*) uint)


(define-gtk-foreign (gtk-tooltips-new) gtktooltips*)
(define-gtk-foreign (gtk-tooltips-set-tip gtktooltips* gtkwidget* string (maybe string)) void)

(define-gtk-foreign (gtk-menu-bar-new) gtkmenubar*)

(define-gtk-foreign (gtk-accel-group-new) gtkaccelgroup*)
;; (define-gtk-foreign (gtk-accel-group-attach void* void*) void) ;; XXX

(define-gtk-foreign (gtk-menu-item-set-submenu gtkmenuitem* gtkwidget*) void)
(define-gtk-foreign (gtk-menu-item-get-submenu gtkmenuitem*) gtkwidget*)

(define-gtk-foreign (gtk-check-menu-item-new) gtkcheckmenuitem*)
(define-gtk-foreign (gtk-check-menu-item-new-with-label string) gtkcheckmenuitem*)
(define-gtk-foreign (gtk-check-menu-item-new-with-mnemonic string) gtkcheckmenuitem*)
(define-gtk-foreign (gtk-check-menu-item-set-active gtkcheckmenuitem* bool) void)
(define-gtk-foreign (gtk-check-menu-item-get-active gtkcheckmenuitem*) bool)
(define-gtk-foreign (gtk-check-menu-item-toggled gtkcheckmenuitem*) void)
(define-gtk-foreign (gtk-check-menu-item-set-inconsistent gtkcheckmenuitem* bool) void)
(define-gtk-foreign (gtk-check-menu-item-get-inconsistent gtkcheckmenuitem*) bool)

(define-gtk-foreign (gtk-radio-menu-item-new (maybe void*)) gtkradiomenuitem*)
(define-gtk-foreign (gtk-radio-menu-item-new-with-label (maybe void*) string) gtkradiomenuitem*)
(define-gtk-foreign (gtk-radio-menu-item-new-with-mnemonic (maybe void*) string) gtkradiomenuitem*)
(define-gtk-foreign (gtk-radio-menu-item-get-group gtkradiomenuitem*) void*)
(define-gtk-foreign (gtk-radio-menu-item-set-group gtkradiomenuitem* (maybe void*)) void)

(define-gtk-foreign (gtk-toolbar-get-type) uint)
(define-gtk-foreign (gtk-toolbar-new) gtktoolbar*)
(define-gtk-foreign (gtk-toolbar-get-orientation gtktoolbar*) gtkorientation)
(define-gtk-foreign (gtk-toolbar-set-orientation gtktoolbar* gtkorientation) void)
(define-gtk-foreign (gtk-toolbar-get-tooltips gtktoolbar*) bool)
(define-gtk-foreign (gtk-toolbar-set-tooltips gtktoolbar* bool) void)
(define-gtk-foreign (gtk-toolbar-get-style gtktoolbar*) gtktoolbarstyle)
(define-gtk-foreign (gtk-toolbar-set-style gtktoolbar* gtktoolbarstyle) void)
'(define-gtk-foreign (gtk-toolbar-append-item 
                 gtktoolbar* string string string gtkwidget* 
                 (-> (gtkwidget* void*) void) (maybe void*))
  void)
(define-gtk-foreign (gtk-toolbar-append-space gtktoolbar*) void)
(define-gtk-foreign (gtk-toolbar-append-widget gtktoolbar* gtkwidget* string string) void)
(define-gtk-foreign (gtk-toolbar-prepend-widget gtktoolbar* gtkwidget* string string) void)
(define-gtk-foreign (gtk-toolbar-insert-widget gtktoolbar* gtkwidget* string string int) void)
'(define-gtk-foreign (gtk-toolbar-append-element 
                 gtktoolbar* uint (maybe gtkwidget*) 
                 (maybe string) string (maybe string) 
                 gtkwidget* (-> (gtkwidget* void*) void) (maybe void*)) 
  gtkwidget*)
'(define-gtk-foreign (gtk-toolbar-prepend-element 
                 gtktoolbar* uint (maybe gtkwidget*) 
                 (maybe string) string (maybe string) 
                 gtkwidget* (-> (gtkwidget* void*) void) (maybe void*)) 
  void*)
'(define-gtk-foreign (gtk-toolbar-prepend-element 
                 gtktoolbar* uint (maybe gtkwidget*)
                 (maybe string) string (maybe string) 
                 gtkwidget* (-> (gtkwidget* void*) void) (maybe void*) int) 
  gtkwidget*)

(define-gtk-foreign (gtk-pixmap-new gdkpixmap* (maybe gdkbitmap*)) gtkpixmap*)

(define-gtk-foreign (gtk-combo-new) gtkcombo*)
(define-gtk-foreign (gtk-combo-set-value-in-list gtkcombo* bool bool) void)
(define-gtk-foreign (gtk-combo-set-use-arrows gtkcombo* bool) void)
(define-gtk-foreign (gtk-combo-set-use-arrows-always gtkcombo* bool) void)
(define-gtk-foreign (gtk-combo-set-case-sensitive gtkcombo* bool) void)
(define-gtk-foreign (gtk-combo-set-item-string gtkcombo* gtkitem* string) void)
(define-gtk-foreign (gtk-combo-set-popdown-strings gtkcombo* glist*) void)
(define-gtk-foreign (gtk-combo-disable-activate gtkcombo*) void)

;; Deprecated in gtk2
;(define-gtk-foreign (gtk-text-new (maybe gtkadjustment*) (maybe gtkadjustment*)) gtktext*)
;(define-gtk-foreign (gtk-text-set-editable  gtktext* bool) void)
;(define-gtk-foreign (gtk-text-set-word-wrap gtktext* bool) void)
;(define-gtk-foreign (gtk-text-set-line-wrap gtktext* bool) void)
;(define-gtk-foreign (gtk-text-set-adjustments gtktext* gtkadjustment* gtkadjustment*) void)
;(define-gtk-foreign (gtk-text-set-point gtktext* uint) void)
;(define-gtk-foreign (gtk-text-get-point gtktext*) uint)
;(define-gtk-foreign (gtk-text-get-length gtktext*) uint)
;(define-gtk-foreign (gtk-text-freeze gtktext*) void)
;(define-gtk-foreign (gtk-text-thaw gtktext*) void)
;(define-gtk-foreign (gtk-text-insert gtktext* gdkfont* gdkcolor* gdkcolor* string int) void)
;(define-gtk-foreign (gtk-text-backward-delete gtktext* uint) bool)
;(define-gtk-foreign (gtk-text-forward-delete gtktext* uint) bool)

(define-gtk-foreign (gtk-text-view-new) gtktextview*)
(define-gtk-foreign (gtk-text-view-new-with-buffer gtktextbuffer*) gtktextview*)
(define-gtk-foreign (gtk-text-view-set-buffer gtktextview* gtktextbuffer*) void)
(define-gtk-foreign (gtk-text-view-get-buffer gtktextview*) gtktextbuffer*)
(define-gtk-foreign (gtk-text-view-scroll-to-mark gtktextview* 
                                              gtktextmark*
                                              double bool double double) void)
(define-gtk-foreign (gtk-text-view-scroll-to-iter gtktextview* gtktextiter* 
                                              double bool double double) void)
(define-gtk-foreign (gtk-text-view-scroll-mark-onscreen gtktextview* gtktextmark*) void)
(define-gtk-foreign (gtk-text-view-place-cursor-onscreen gtktextview*) bool)
(define-gtk-foreign (gtk-text-view-get-visible-rect gtktextview* gdkrectangle*) void)
(define-gtk-foreign (gtk-text-view-get-iter-location gtktextview* 
                                                 gtktextiter* gdkrectangle*) void)
(define-gtk-foreign (gtk-text-view-get-line-at-y gtktextview* 
                                             gtktextiter* int int*) void)
(define-gtk-foreign (gtk-text-view-get-line-yrange gtktextview* 
                                               gtktextiter* int* int*) void)
(define-gtk-foreign (gtk-text-view-get-iter-at-location gtktextview* 
                                                    gtktextiter* int int) void)
(define-gtk-foreign (gtk-text-view-get-iter-at-position gtktextview* 
                                                    gtktextiter* int* int int) void)
(define-gtk-foreign (gtk-text-view-buffer-to-window-coords gtktextview*
                                                       uint int int int* int*) void)
(define-gtk-foreign (gtk-text-view-window-to-buffer-coords gtktextview*
                                                       uint int int int* int*) void)
(define-gtk-foreign (gtk-text-view-get-window gtktextview* gtktextwindowtype) gdkwindow*)
(define-gtk-foreign (gtk-text-view-get-window-type gtktextview* gdkwindow*) gtktextwindowtype)
(define-gtk-foreign (gtk-text-view-set-border-window-size gtktextview* gtktextwindowtype int) void)
(define-gtk-foreign (gtk-text-view-get-border-window-size gtktextview* gtktextwindowtype) int)
(define-gtk-foreign (gtk-text-view-forward-display-line gtktextview* gtktextiter*) bool)
(define-gtk-foreign (gtk-text-view-backward-display-line gtktextview* gtktextiter*) bool)
(define-gtk-foreign (gtk-text-view-forward-display-line-end gtktextview* gtktextiter*) bool)
(define-gtk-foreign (gtk-text-view-backward-display-line-start gtktextview* gtktextiter*) bool)
(define-gtk-foreign (gtk-text-view-starts-display-line gtktextview* gtktextiter*) bool)
(define-gtk-foreign (gtk-text-view-move-visually gtktextview* gtktextiter* int) bool)
(define-gtk-foreign (gtk-text-view-add-child-at-anchor gtktextview* 
                                                   gtkwidget* gtktextchildanchor*) void)
(define-gtk-foreign (gtk-text-child-anchor-new) gtktextchildanchor*)
(define-gtk-foreign (gtk-text-child-anchor-get-widgets gtktextchildanchor*) glist*)
(define-gtk-foreign (gtk-text-child-anchor-get-deleted gtktextchildanchor*) glist*)
(define-gtk-foreign (gtk-text-view-add-child-in-window
                 gtktextview* gtkwidget* gtktextwindowtype int int) void)
(define-gtk-foreign (gtk-text-view-move-child gtktextview* gtkwidget* int int) void)
(define-gtk-foreign (gtk-text-view-set-wrap-mode gtktextview* gtkwrapmode) void)
(define-gtk-foreign (gtk-text-view-get-wrap-mode gtktextview*) gtkwrapmode)
(define-gtk-foreign (gtk-text-view-set-editable gtktextview* bool) void)
(define-gtk-foreign (gtk-text-view-get-editable gtktextview*) bool)
(define-gtk-foreign (gtk-text-view-set-cursor-visible gtktextview* bool) void)
(define-gtk-foreign (gtk-text-view-get-cursor-visible gtktextview*) bool)
(define-gtk-foreign (gtk-text-view-set-overwrite gtktextview* bool) void)
(define-gtk-foreign (gtk-text-view-get-overwrite gtktextview*) bool)
(define-gtk-foreign (gtk-text-view-set-pixels-above-lines gtktextview* int) void)
(define-gtk-foreign (gtk-text-view-get-pixels-above-lines gtktextview*) int)
(define-gtk-foreign (gtk-text-view-set-pixels-below-lines gtktextview* int) void)
(define-gtk-foreign (gtk-text-view-get-pixels-below-lines gtktextview*) int)
(define-gtk-foreign (gtk-text-view-set-pixels-inside-wrap gtktextview* int) void)
(define-gtk-foreign (gtk-text-view-get-pixels-inside-wrap gtktextview*) int)

(define-gtk-foreign (gtk-text-buffer-new (maybe gtktexttagtable*)) gtktextbuffer*)
(define-gtk-foreign (gtk-text-buffer-get-line-count gtktextbuffer*) int)
(define-gtk-foreign (gtk-text-buffer-get-char-count gtktextbuffer*) int)
(define-gtk-foreign (gtk-text-buffer-get-tag-table gtktextbuffer*) gtktexttagtable*)
(define-gtk-foreign (gtk-text-buffer-set-text gtktextbuffer* string int) void)
(define-gtk-foreign (gtk-text-buffer-insert gtktextbuffer* gtktextiter* string int) void)
(define-gtk-foreign (gtk-text-buffer-insert-at-cursor gtktextbuffer* string int) void)
(define-gtk-foreign (gtk-text-buffer-insert-interactive gtktextbuffer* gtktextiter* string int bool) bool)
(define-gtk-foreign (gtk-text-buffer-insert-interactive-at-cursor gtktextbuffer* string int bool) bool)
(define-gtk-foreign (gtk-text-buffer-insert-range gtktextbuffer* gtktextiter* gtktextiter* gtktextiter*) void)
(define-gtk-foreign (gtk-text-buffer-insert-range-interactive gtktextbuffer* gtktextiter* gtktextiter* gtktextiter* bool) bool)
;; can't handle varargs with define-gtk-foreign
;(define-gtk-foreign (gtk-text-buffer-insert-with-tags gtktextbuffer* gtktextiter* string int gtktexttag* ...) void)
;(define-gtk-foreign (gtk-text-buffer-insert-with-tags-by-name gtktextbuffer* gtktextiter* string int string ...) void)
(define-gtk-foreign (gtk-text-buffer-delete gtktextbuffer* gtktextiter* gtktextiter*) void)
(define-gtk-foreign (gtk-text-buffer-delete-interactive gtktextbuffer* gtktextiter* gtktextiter* bool) bool)
(define-gtk-foreign (gtk-text-buffer-backspace gtktextbuffer* gtktextiter* bool bool) bool)
(define-gtk-foreign (gtk-text-buffer-get-text gtktextbuffer* gtktextiter* gtktextiter* bool) string)
(define-gtk-foreign (gtk-text-buffer-get-slice gtktextbuffer* gtktextiter* gtktextiter* bool) string)
(define-gtk-foreign (gtk-text-buffer-insert-pixbuf gtktextbuffer* gtktextiter* gdkpixbuf*) void)
(define-gtk-foreign (gtk-text-buffer-insert-child-anchor gtktextbuffer* gtktextiter* gtktextchildanchor*) void)
(define-gtk-foreign (gtk-text-buffer-create-child-anchor gtktextbuffer* gtktextiter*) gtktextchildanchor*)
(define-gtk-foreign (gtk-text-buffer-create-mark gtktextbuffer* (maybe string) gtktextiter* bool) gtktextmark*)
(define-gtk-foreign (gtk-text-buffer-move-mark gtktextbuffer* gtktextmark* gtktextiter*) void)
(define-gtk-foreign (gtk-text-buffer-delete-mark gtktextbuffer* gtktextmark*) void)
(define-gtk-foreign (gtk-text-buffer-get-mark gtktextbuffer* string) (maybe gtktextmark*))
(define-gtk-foreign (gtk-text-buffer-move-mark-by-name gtktextbuffer* string gtktextiter*) void)
(define-gtk-foreign (gtk-text-buffer-delete-mark-by-name gtktextbuffer* string) void)
(define-gtk-foreign (gtk-text-buffer-get-insert gtktextbuffer*) gtktextmark*)
(define-gtk-foreign (gtk-text-buffer-get-selection-bound gtktextbuffer*) gtktextmark*)
(define-gtk-foreign (gtk-text-buffer-place-cursor gtktextbuffer* gtktextiter*) void)
(define-gtk-foreign (gtk-text-buffer-select-range gtktextbuffer* gtktextiter* gtktextiter*) void)
(define-gtk-foreign (gtk-text-buffer-apply-tag gtktextbuffer* gtktexttag* gtktextiter* gtktextiter*) void)
(define-gtk-foreign (gtk-text-buffer-remove-tag gtktextbuffer* gtktexttag* gtktextiter* gtktextiter*) void)
(define-gtk-foreign (gtk-text-buffer-apply-tag-by-name gtktextbuffer* string gtktextiter* gtktextiter*) void)
(define-gtk-foreign (gtk-text-buffer-remove-tag-by-name gtktextbuffer* string gtktextiter* gtktextiter*) void)
(define-gtk-foreign (gtk-text-buffer-remove-all-tags gtktextbuffer* gtktextiter* gtktextiter*) void)
;; Again, var args are not yet supported in define-gtk-foreign.
;; (But then again, why not support them?)
;(define-gtk-foreign (gtk-text-buffer-create-tag gtktextbuffer* string string ...) gtktexttag*)
(define-gtk-foreign (gtk-text-buffer-get-iter-at-line-offset gtktextbuffer* gtktextiter* int int) void)
(define-gtk-foreign (gtk-text-buffer-get-iter-at-line-index gtktextbuffer* gtktextiter* int int) void)
(define-gtk-foreign (gtk-text-buffer-get-iter-at-offset gtktextbuffer* gtktextiter* int) void)
(define-gtk-foreign (gtk-text-buffer-get-iter-at-line gtktextbuffer* gtktextiter* int) void)
(define-gtk-foreign (gtk-text-buffer-get-start-iter gtktextbuffer* gtktextiter*) void)
(define-gtk-foreign (gtk-text-buffer-get-end-iter gtktextbuffer* gtktextiter*) void)
(define-gtk-foreign (gtk-text-buffer-get-bounds gtktextbuffer* gtktextiter* gtktextiter*) void)
(define-gtk-foreign (gtk-text-buffer-get-iter-at-mark gtktextbuffer* gtktextiter* gtktextmark*) void)
(define-gtk-foreign (gtk-text-buffer-get-iter-at-child-anchor gtktextbuffer* gtktextiter* gtktextchildanchor*) void)
(define-gtk-foreign (gtk-text-buffer-get-modified gtktextbuffer*) bool)
(define-gtk-foreign (gtk-text-buffer-set-modified gtktextbuffer* bool) void)
(define-gtk-foreign (gtk-text-buffer-add-selection-clipboard gtktextbuffer* gtkclipboard*) void)
(define-gtk-foreign (gtk-text-buffer-remove-selection-clipboard gtktextbuffer* gtkclipboard*) void)
(define-gtk-foreign (gtk-text-buffer-cut-clipboard gtktextbuffer* gtkclipboard* bool) void)
(define-gtk-foreign (gtk-text-buffer-copy-clipboard gtktextbuffer* gtkclipboard*) void)
(define-gtk-foreign (gtk-text-buffer-paste-clipboard gtktextbuffer* gtkclipboard* (maybe gtktextiter*) bool) void)
(define-gtk-foreign (gtk-text-buffer-get-selection-bounds gtktextbuffer* gtktextiter* gtktextiter*) bool)
(define-gtk-foreign (gtk-text-buffer-delete-selection gtktextbuffer* bool bool) bool)
(define-gtk-foreign (gtk-text-buffer-begin-user-action gtktextbuffer*) void)
(define-gtk-foreign (gtk-text-buffer-end-user-action gtktextbuffer*) void)

(define-gtk-foreign (gtk-text-iter-get-buffer gtktextiter*) gtktextbuffer*)
(define-gtk-foreign (gtk-text-iter-copy gtktextiter*) gtktextiter*)
(define-gtk-foreign (gtk-text-iter-free gtktextiter*) void)
(define-gtk-foreign (gtk-text-iter-get-offset gtktextiter*) int)
(define-gtk-foreign (gtk-text-iter-get-line gtktextiter*) int)
(define-gtk-foreign (gtk-text-iter-get-line-offset gtktextiter*) int)
(define-gtk-foreign (gtk-text-iter-get-line-index gtktextiter*) int)
(define-gtk-foreign (gtk-text-iter-get-visible-line-offset gtktextiter*) int)
(define-gtk-foreign (gtk-text-iter-get-visible-line-index gtktextiter*) int)
(define-gtk-foreign (gtk-text-iter-get-char gtktextiter*) uint) ;; gunichar is guint32...
(define-gtk-foreign (gtk-text-iter-get-slice gtktextiter* gtktextiter*) string)
(define-gtk-foreign (gtk-text-iter-get-text   gtktextiter* gtktextiter*) string)
(define-gtk-foreign (gtk-text-iter-get-visible-slice gtktextiter* gtktextiter*) string)
(define-gtk-foreign (gtk-text-iter-get-visible-text  gtktextiter* gtktextiter*) string)
(define-gtk-foreign (gtk-text-iter-get-child-anchor gtktextiter*) gtktextchildanchor*)
(define-gtk-foreign (gtk-text-iter-get-toggled-tags gtktextiter* bool) gslist*)
(define-gtk-foreign (gtk-text-iter-begins-tag gtktextiter* gtktexttag*) bool)
(define-gtk-foreign (gtk-text-iter-ends-tag gtktextiter* gtktexttag*) bool)
(define-gtk-foreign (gtk-text-iter-toggles-tag gtktextiter* gtktexttag*) bool)
(define-gtk-foreign (gtk-text-iter-has-tag gtktextiter* gtktexttag*) bool)
(define-gtk-foreign (gtk-text-iter-get-tags gtktextiter*) gslist*)
(define-gtk-foreign (gtk-text-iter-editable gtktextiter* bool) bool)
(define-gtk-foreign (gtk-text-iter-can-insert gtktextiter* bool) bool)
(define-gtk-foreign (gtk-text-iter-starts-word gtktextiter*) bool)
(define-gtk-foreign (gtk-text-iter-ends-word gtktextiter*) bool)
(define-gtk-foreign (gtk-text-iter-inside-word gtktextiter*) bool)
(define-gtk-foreign (gtk-text-iter-starts-sentence gtktextiter*) bool)
(define-gtk-foreign (gtk-text-iter-ends-sentence gtktextiter*) bool)
(define-gtk-foreign (gtk-text-iter-inside-sentence gtktextiter*) bool)
(define-gtk-foreign (gtk-text-iter-starts-line gtktextiter*) bool)
(define-gtk-foreign (gtk-text-iter-ends-line gtktextiter*) bool)
(define-gtk-foreign (gtk-text-iter-is-cursor-position gtktextiter*) bool)
(define-gtk-foreign (gtk-text-iter-get-chars-in-line gtktextiter*) int)
(define-gtk-foreign (gtk-text-iter-get-bytes-in-line gtktextiter*) int)
;(define-gtk-foreign (gtk-text-iter-get-attributes gtktextiter* gtktextattributes*) bool)
;(define-gtk-foreign (gtk-text-iter-get-language gtktextiter*) pangolanguage*)
(define-gtk-foreign (gtk-text-iter-is-end gtktextiter*) bool)
(define-gtk-foreign (gtk-text-iter-is-start gtktextiter*) bool)

(define-gtk-foreign (gtk-text-iter-forward-char gtktextiter*) bool)
(define-gtk-foreign (gtk-text-iter-backward-char gtktextiter*) bool)
(define-gtk-foreign (gtk-text-iter-forward-chars gtktextiter* int) bool)
(define-gtk-foreign (gtk-text-iter-backward-chars gtktextiter* int) bool)
(define-gtk-foreign (gtk-text-iter-forward-line gtktextiter*) bool)
(define-gtk-foreign (gtk-text-iter-backward-line gtktextiter*) bool)
(define-gtk-foreign (gtk-text-iter-forward-lines gtktextiter* int) bool)
(define-gtk-foreign (gtk-text-iter-backward-lines gtktextiter* int) bool)
(define-gtk-foreign (gtk-text-iter-forward-word-end gtktextiter*) bool)
(define-gtk-foreign (gtk-text-iter-backward-word-start gtktextiter*) bool)
(define-gtk-foreign (gtk-text-iter-forward-word-ends gtktextiter* int) bool)
(define-gtk-foreign (gtk-text-iter-backward-word-starts gtktextiter* int) bool)
(define-gtk-foreign (gtk-text-iter-forward-visible-word-end gtktextiter*) bool)
(define-gtk-foreign (gtk-text-iter-backward-visible-word-start gtktextiter*) bool)
(define-gtk-foreign (gtk-text-iter-forward-visible-word-ends gtktextiter* int) bool)
(define-gtk-foreign (gtk-text-iter-backward-visible-word-starts gtktextiter* int) bool)
(define-gtk-foreign (gtk-text-iter-forward-cursor-position gtktextiter*) bool)
(define-gtk-foreign (gtk-text-iter-backward-cursor-position gtktextiter*) bool)
(define-gtk-foreign (gtk-text-iter-forward-cursor-positions gtktextiter* int) bool)
(define-gtk-foreign (gtk-text-iter-backward-cursor-positions gtktextiter* int) bool)
(define-gtk-foreign (gtk-text-iter-forward-visible-cursor-position gtktextiter*) bool)
(define-gtk-foreign (gtk-text-iter-backward-visible-cursor-position gtktextiter*) bool)
(define-gtk-foreign (gtk-text-iter-forward-visible-cursor-positions gtktextiter* int) bool)
(define-gtk-foreign (gtk-text-iter-backward-visible-cursor-positions gtktextiter* int) bool)

(define-gtk-foreign (gtk-text-iter-set-offset gtktextiter* int) void)
(define-gtk-foreign (gtk-text-iter-set-line gtktextiter* int) void)
(define-gtk-foreign (gtk-text-iter-set-line-offset gtktextiter* int) void)
(define-gtk-foreign (gtk-text-iter-set-line-index gtktextiter* int) void)
(define-gtk-foreign (gtk-text-iter-forward-to-end gtktextiter*) void)
(define-gtk-foreign (gtk-text-iter-forward-to-line-end gtktextiter*) void)
(define-gtk-foreign (gtk-text-iter-set-visible-line-offset gtktextiter* int) void)
(define-gtk-foreign (gtk-text-iter-set-visible-line-index gtktextiter* int) void)

(define-gtk-foreign (gtk-text-iter-forward-to-tag-toggle gtktextiter* gtktexttag*) bool)
(define-gtk-foreign (gtk-text-iter-backward-to-tag-toggle gtktextiter* gtktexttag*) bool)
(define-gtk-foreign (gtk-text-iter-forward-find-char gtktextiter* (-> (uint void*) bool) void* gtktextiter*) bool)
(define-gtk-foreign (gtk-text-iter-backward-find-char gtktextiter* (-> (uint void*) bool) void* gtktextiter*) bool)
;; FSK is too lazy to add the gtktextsearchflags enum
;(define-gtk-foreign (gtk-text-iter-forward-search gtktextiter* string gtktextsearchflags gtktextiter* gtktextiter* gtktextiter*) bool)
;(define-gtk-foreign (gtk-text-iter-backward-search gtktextiter* string gtktextsearchflags gtktextiter* gtktextiter* gtktextiter*) bool)
(define-gtk-foreign (gtk-text-iter-equal gtktextiter* gtktextiter*) bool)
(define-gtk-foreign (gtk-text-iter-compare gtktextiter* gtktextiter*) bool)
(define-gtk-foreign (gtk-text-iter-in-range gtktextiter* gtktextiter* gtktextiter*) bool)
(define-gtk-foreign (gtk-text-iter-order gtktextiter* gtktextiter*) void)

(define-gtk-foreign (gtk-clipboard-get gdkatom*) gtkclipboard*)
; FSK is too lazy to add gdkdisplay* now
;(define-gtk-foreign (gtk-clipboard-get-for-display gdkdisplay* gdkatom*) gtkclipboard*)
;(define-gtk-foreign (gtk-clipboard-get-display gtkclipboard*) gdkdisplay*)
(define-gtk-foreign (gtk-clipboard-set-text gtkclipboard* string int) void)
(define-gtk-foreign (gtk-clipboard-set-image gtkclipboard* gdkpixbuf*) void)

(define-gtk-foreign (gtk-dialog-new) gtkdialog*)
(define gtk-dialog-new-with-buttons 
  (lambda (s w f . names)
    (let ((p (foreign-procedure "gtk_dialog_new_with_buttons"
                                `(string gtkwindow* gtkdialogflags
                                         ,@(map (lambda (x) 'string) names)
                                         string) ;; marked end of names
                                'gtkdialog*)))
      (apply p s w f (reverse (cons #f (reverse names)))))))
(define-gtk-foreign (gtk-dialog-run gtkdialog*) int)
(define-gtk-foreign (gtk-dialog-response gtkdialog* int) void)
(define-gtk-foreign (gtk-dialog-add-button gtkdialog* string int) gtkwidget*)
(define-gtk-foreign (gtk-dialog-add-action-widget gtkdialog* gtkwidget* int) void)
(define-gtk-foreign (gtk-dialog-get-has-separator gtkdialog*) bool)
(define-gtk-foreign (gtk-dialog-set-default-response gtkdialog* int) void)
(define-gtk-foreign (gtk-dialog-set-has-separator gtkdialog* bool) void)
(define-gtk-foreign (gtk-dialog-set-response-sensitive gtkdialog* int bool) void)
(define-gtk-foreign (gtk-alternative-dialog-button-order gdkscreen*) bool)
(define-gtk-foreign (gtk-dialog-set-alternative-button-order-from-array 
                 gtkdialog* int int*) void)

(define-gtk-foreign (gtk-invisible-new) gtkinvisible*)
(define-gtk-foreign (gtk-invisible-new-for-screen gdkscreen*) gtkinvisible*)
(define-gtk-foreign (gtk-invisible-set-screen gtkinvisible* gdkscreen*) void)
(define-gtk-foreign (gtk-invisible-get-screen gtkinvisible*) gdkscreen*)

;(define-gtk-foreign (gtk-message-dialog-new gtkwindow* uint 

(define-gtk-foreign (gtk-message-dialog-new gtkwindow* gtkdialogflags 
                                        gtkmessagetype gtkbuttonstype string) 
  gtkmessagedialog*)
(define-gtk-foreign (gtk-message-dialog-new-with-markup gtkwindow* gtkdialogflags
                                                    gtkmessagetype gtkbuttonstype
                                                    string)
  gtkmessagedialog*)
(define-gtk-foreign (gtk-message-dialog-set-markup gtkmessagedialog* string) void)
(define-gtk-foreign (gtk-message-dialog-format-secondary-text gtkmessagedialog* string) 
  void)
(define-gtk-foreign (gtk-message-dialog-format-secondary-markup gtkmessagedialog* string)
  void)

(define-gtk-foreign (gtk-window-new gtkwindowtype) gtkwindow*)
(define-gtk-foreign (gtk-window-set-title gtkwindow* string) void)
(define-gtk-foreign (gtk-window-set-wmclass gtkwindow* string string) void)
(define-gtk-foreign (gtk-window-set-policy gtkwindow* int int int) void)
(define-gtk-foreign (gtk-window-set-resizable gtkwindow* bool) void)
(define-gtk-foreign (gtk-window-get-resizable gtkwindow*) bool)
(define-gtk-foreign (gtk-window-add-accel-group gtkwindow* gtkaccelgroup*) void)
(define-gtk-foreign (gtk-window-remove-accel-group gtkwindow* gtkaccelgroup*) void)
(define-gtk-foreign (gtk-window-activate-focus gtkwindow*) bool)
(define-gtk-foreign (gtk-window-activate-default gtkwindow*) bool)
(define-gtk-foreign (gtk-window-set-modal gtkwindow* bool) void)
(define-gtk-foreign (gtk-window-set-default-size gtkwindow* int int) void)
(define-gtk-foreign (gtk-window-set-geometry-hints gtkwindow* gtkwidget* gdkgeometry* gdkwindowhints) void)
(define-gtk-foreign (gtk-window-set-gravity gtkwindow* gdkgravity) void)
(define-gtk-foreign (gtk-window-get-gravity gtkwindow*) gdkgravity)
(define-gtk-foreign (gtk-window-set-position gtkwindow* gtkwindowposition) void)
(define-gtk-foreign (gtk-window-set-transient-for gtkwindow* gtkwindow*) void)
(define-gtk-foreign (gtk-window-set-destroy-with-parent gtkwindow* bool) void)
(define-gtk-foreign (gtk-window-set-screen gtkwindow* gdkscreen*) void)
(define-gtk-foreign (gtk-window-get-screen gtkwindow*) gdkscreen*)
(define-gtk-foreign (gtk-window-is-active gtkwindow*) bool)
(define-gtk-foreign (gtk-window-has-toplevel-focus gtkwindow*) bool)
; gtk-window-list-toplevels
(define-gtk-foreign (gtk-window-add-mnemonic gtkwindow* uint gtkwidget*) void)
(define-gtk-foreign (gtk-window-remove-mnemonic gtkwindow* uint gtkwidget*) void)
(define-gtk-foreign (gtk-window-mnemonic-activate gtkwidget* uint gdkmodifiertype) bool)
(define-gtk-foreign (gtk-window-activate-key gtkwidget* gdkeventkey*) bool)
(define-gtk-foreign (gtk-window-propagate-key-event gtkwidget* gdkeventkey*) bool)
(define-gtk-foreign (gtk-window-get-focus gtkwindow*) gtkwidget*)
(define-gtk-foreign (gtk-window-set-focus gtkwindow* gtkwidget*) void)
(define-gtk-foreign (gtk-window-set-default gtkwindow* gtkwidget*) void)
(define-gtk-foreign (gtk-window-present gtkwindow*) void)
(define-gtk-foreign (gtk-window-iconify gtkwindow*) void)
(define-gtk-foreign (gtk-window-deiconify gtkwindow*) void)
(define-gtk-foreign (gtk-window-stick gtkwindow*) void)
(define-gtk-foreign (gtk-window-unstick gtkwindow*) void)
(define-gtk-foreign (gtk-window-maximize gtkwindow*) void)
(define-gtk-foreign (gtk-window-unmaximize gtkwindow*) void)
(define-gtk-foreign (gtk-window-fullscreen gtkwindow*) void)
(define-gtk-foreign (gtk-window-unfullscreen gtkwindow*) void)

(define-gtk-foreign (gtk-window-set-keep-above gtkwindow* bool) void)
(define-gtk-foreign (gtk-window-set-keep-below gtkwindow* bool) void)
(define-gtk-foreign (gtk-window-begin-resize-drag gtkwindow* gdkwindowedge int int int uint) void)
(define-gtk-foreign (gtk-window-begin-move-drag gtkwindow* int int int uint) void)
(define-gtk-foreign (gtk-window-set-decorated gtkwindow* bool) void)
(define-gtk-foreign (gtk-window-set-frame-dimensions gtkwindow* int int int int) void)
(define-gtk-foreign (gtk-window-set-has-frame gtkwindow* bool) void)
(define-gtk-foreign (gtk-window-set-mnemonic-modifier gtkwindow* gdkmodifiertype) void)
(define-gtk-foreign (gtk-window-set-role gtkwindow* string) void)
(define-gtk-foreign (gtk-window-set-type-hint gtkwindow* gdkwindowtypehint) void)
(define-gtk-foreign (gtk-window-set-skip-taskbar-hint gtkwindow* bool) void)
(define-gtk-foreign (gtk-window-set-skip-pager-hint gtkwindow* bool) void)
(define-gtk-foreign (gtk-window-set-accept-focus gtkwindow* bool) void)
(define-gtk-foreign (gtk-window-set-focus-on-map gtkwindow* bool) void)
(define-gtk-foreign (gtk-window-get-decorated gtkwindow*) bool)
;(define-gtk-foreign (gtk-window-get-default-icon-list) glist*)
(define-gtk-foreign (gtk-window-get-default-size gtkwindow* (ret int) (ret int)) void)
(define-gtk-foreign (gtk-window-get-destroy-with-parent gtkwindow*) bool)
(define-gtk-foreign (gtk-window-get-frame-dimensions 
                 gtkwindow* (ret int) (ret int) (ret int) (ret int))  void)
(define-gtk-foreign (gtk-window-get-has-frame gtkwindow*) bool)
(define-gtk-foreign (gtk-window-get-icon gtkwindow*) gdkpixbuf*)
;(define-gtk-foreign (gtk-window-get-icon-list gtkwindow*) gslist*)
(define-gtk-foreign (gtk-window-get-icon-name gtkwindow*) string)
(define-gtk-foreign (gtk-window-get-mnemonic-modifier gtkwindow*) gdkmodifiertype)
(define-gtk-foreign (gtk-window-get-modal gtkwindow*) bool)
(define-gtk-foreign (gtk-window-get-position gtkwindow* (ret int) (ret int)) void)
(define-gtk-foreign (gtk-window-get-role gtkwindow*) string)
(define-gtk-foreign (gtk-window-get-size gtkwindow* (ret int) (ret int)) void)
(define-gtk-foreign (gtk-window-get-title gtkwindow*) string)
(define-gtk-foreign (gtk-window-get-transient-for gtkwindow*) gtkwindow*)
(define-gtk-foreign (gtk-window-get-type-hint gtkwindow*) gdkwindowtypehint)
(define-gtk-foreign (gtk-window-get-skip-taskbar-hint gtkwindow*) bool)
(define-gtk-foreign (gtk-window-get-skip-pager-hint gtkwindow*) bool)
(define-gtk-foreign (gtk-window-get-accept-focus gtkwindow*) bool)
(define-gtk-foreign (gtk-window-get-focus-on-map gtkwindow*) bool)
(define-gtk-foreign (gtk-window-move gtkwindow* int int) void)
(define-gtk-foreign (gtk-window-parse-geometry gtkwindow* string) bool)
(define-gtk-foreign (gtk-window-reshow-with-initial-size gtkwindow*) void)
(define-gtk-foreign (gtk-window-resize gtkwindow* int int) void)
;(define-gtk-foreign (gtk-window-set-default-icon-list glist*) void)
(define-gtk-foreign (gtk-window-set-default-icon gdkpixbuf*) void)
;(define-gtk-foreign (gtk-window-set-default-icon-from-file string gerror**) bool)
(define-gtk-foreign (gtk-window-set-default-icon-name string) void)
(define-gtk-foreign (gtk-window-set-icon gtkwindow* gdkpixbuf*) void)
;(define-gtk-foreign (gtk-window-set-icon-list gtkwindow* glist*) void)
;(define-gtk-foreign (gtk-window-set-icon-from-file gtkwindow* string gerror**) bool)
(define-gtk-foreign (gtk-window-set-icon-name gtkwindow* string) void)
(define-gtk-foreign (gtk-window-set-auto-startup-notification bool) void)
(define-gtk-foreign (gtk-decorated-window-init gtkwindow*) void)
(define-gtk-foreign (gtk-decorated-window-calculate-frame-size gtkwindow*) void)
(define-gtk-foreign (gtk-decorated-window-set-title gtkwindow* string) void)
(define-gtk-foreign (gtk-decorated-window-move-resize-window gtkwindow* int int int int) void)

(define-gtk-foreign (gtk-window-group-new) gtkwindowgroup*)
(define-gtk-foreign (gtk-window-group-add-window gtkwindowgroup* gtkwindow*) void)
(define-gtk-foreign (gtk-window-group-remove-window gtkwindowgroup* gtkwindow*) void)

(define-gtk-foreign (gtk-about-dialog-new) gtkaboutdialog*)
(define-gtk-foreign (gtk-about-dialog-get-name gtkaboutdialog*) string)
(define-gtk-foreign (gtk-about-dialog-set-name gtkaboutdialog* string) void)
(define-gtk-foreign (gtk-about-dialog-get-version gtkaboutdialog*) string)
(define-gtk-foreign (gtk-about-dialog-set-version gtkaboutdialog* string) void)
(define-gtk-foreign (gtk-about-dialog-get-copyright gtkaboutdialog*) string)
(define-gtk-foreign (gtk-about-dialog-set-copyright gtkaboutdialog* string) void)
(define-gtk-foreign (gtk-about-dialog-get-comments gtkaboutdialog*) string)
(define-gtk-foreign (gtk-about-dialog-set-comments gtkaboutdialog* string) void)
(define-gtk-foreign (gtk-about-dialog-get-license gtkaboutdialog*) string)
(define-gtk-foreign (gtk-about-dialog-set-license gtkaboutdialog* string) void)
(define-gtk-foreign (gtk-about-dialog-get-website gtkaboutdialog*) string)
(define-gtk-foreign (gtk-about-dialog-set-website gtkaboutdialog* string) void)
(define-gtk-foreign (gtk-about-dialog-get-website-label gtkaboutdialog*) string)
(define-gtk-foreign (gtk-about-dialog-set-website-label gtkaboutdialog* string) void)
;(define-gtk-foreign (gtk-about-dialog-get-authors gtkaboutdialog*) stringarray)
;(define-gtk-foreign (gtk-about-dialog-set-authors gtkaboutdialog* stringarray) void)
;(define-gtk-foreign (gtk-about-dialog-get-artists gtkaboutdialog*) stringarray)
;(define-gtk-foreign (gtk-about-dialog-set-artists gtkaboutdialog* stringarray) void)
;(define-gtk-foreign (gtk-about-dialog-get-documenters gtkaboutdialog*) stringarray)
;(define-gtk-foreign (gtk-about-dialog-set-documenters gtkaboutdialog* stringarray) void)
(define-gtk-foreign (gtk-about-dialog-get-logo gtkaboutdialog*) gdkpixbuf*)
(define-gtk-foreign (gtk-about-dialog-set-logo gtkaboutdialog* gdkpixbuf*) void)
(define-gtk-foreign (gtk-about-dialog-get-logo-icon-name gtkaboutdialog*) string)
(define-gtk-foreign (gtk-about-dialog-set-logo-icon-name gtkaboutdialog* string) void)
;; gtk-about-dialog-set-email-hook gtk-about-dialog-set-url-hook 
(define-gtk-foreign (gtk-show-about-dialog gtkaboutdialog* string) void)

(define-gtk-foreign (gtk-accel-label-new string) gtkaccellabel*)
;(define-gtk-foreign (gtk-accel-label-set-accel-closure gtkaccellabel* gclosure*) void)
(define-gtk-foreign (gtk-accel-label-get-accel-widget gtkaccellabel*) gtkwidget*)
(define-gtk-foreign (gtk-accel-label-set-accel-widget gtkaccellabel* gtkwidget*) void)
(define-gtk-foreign (gtk-accel-label-get-accel-width gtkaccellabel*) uint)
(define-gtk-foreign (gtk-accel-label-refetch gtkaccellabel*) bool)

(define-gtk-foreign (gtk-image-get-icon-set gtkimage* (ret gtkiconset*) (ret gtkiconsize)) void)
(define-gtk-foreign (gtk-image-get-image gtkimage* (ret gdkimage*) (ret gdkbitmap*)) void)
(define-gtk-foreign (gtk-image-get-pixbuf gtkimage*) gdkpixbuf*)
(define-gtk-foreign (gtk-image-get-pixmap gtkimage* (ret gdkpixmap*) (ret gdkbitmap*)) void)
(define-gtk-foreign (gtk-image-get-stock gtkimage* (ret string) (ret gtkiconsize)) void)
;(define-gtk-foreign (gtk-image-get-animation gtkimage*) gtkpixbufanimation*)
(define-gtk-foreign (gtk-image-get-icon-name gtkimage* (ret string) (ret gtkiconsize)) void)
(define-gtk-foreign (gtk-image-get-storage-type gtkimage*) gtkimagetype)
(define-gtk-foreign (gtk-image-new-from-file string) gtkwidget*)
(define-gtk-foreign (gtk-image-new-from-icon-set gtkiconset* gtkiconsize) gtkimage*)
(define-gtk-foreign (gtk-image-new-from-image gdkimage* gdkbitmap*) gtkimage*)
(define-gtk-foreign (gtk-image-new-from-pixbuf gdkpixbuf*) gtkimage*)
(define-gtk-foreign (gtk-image-new-from-pixmap gdkpixmap* gdkbitmap*) gtkimage*)
(define-gtk-foreign (gtk-image-new-from-stock string gtkiconsize) gtkimage*)
;(define-gtk-foreign (gtk-image-new-from-animation gtkpixbufanimation*) gtkimage*)
(define-gtk-foreign (gtk-image-new-from-icon-name string gtkiconsize) gtkimage*)
(define-gtk-foreign (gtk-image-set-from-file gtkimage* string) void)
(define-gtk-foreign (gtk-image-set-from-icon-set gtkimage* gtkiconset* gtkiconsize) void)
(define-gtk-foreign (gtk-image-set-from-image gtkimage* gdkimage* gdkbitmap*) void)
(define-gtk-foreign (gtk-image-set-from-pixbuf gtkimage* gdkpixbuf*) gtkimage*)
(define-gtk-foreign (gtk-image-set-from-pixmap gtkimage* gdkpixmap* gdkbitmap*) gtkimage*)
(define-gtk-foreign (gtk-image-set-from-stock gtkimage* string gtkiconsize) gtkimage*)
;(define-gtk-foreign (gtk-image-set-from-animation gtkimage* gtkpixbufanimation*) gtkimage*)
(define-gtk-foreign (gtk-image-set-from-icon-name gtkimage* string gtkiconsize) void)
(define-gtk-foreign (gtk-image-new) gtkimage*)
;(define-gtk-foreign (gtk-image-set) gtkimage* gtkimage* gdkbitmap*)
(define-gtk-foreign (gtk-image-get gtkimage* (ret gdkimage*) (ret gdkbitmap*)) void)
(define-gtk-foreign (gtk-image-set-pixel-size gtkimage* int) void)
(define-gtk-foreign (gtk-image-get-pixel-size gtkimage*) int)

(define-cfields-offsets/target-dep-paths ("gtk/gtk.h") 
  (fields "GtkObject" (gtkobject-flags-offset "flags"))
  (fields "GtkDialog" 
          (gtkdialog-vbox-offset "vbox")
          (gtkdialog-action-area-offset "action_area"))
  (fields "GtkFileSelection" 
          (gtkfilesel-dir-list-offset "dir_list")
          (gtkfilesel-file-list-offset "file_list")
          (gtkfilesel-selection-entry-offset "selection_entry")
          (gtkfilesel-selection-text-offset "selection_text")
          (gtkfilesel-main-vbox-offset "main_vbox")
          (gtkfilesel-ok-button-offset "ok_button")
          (gtkfilesel-cancel-button-offset "cancel_button")
          (gtkfilesel-help-button-offset "help_button")
          (gtkfilesel-history-pulldown-offset "history_pulldown")
          (gtkfilesel-history-menu-offset "history_menu")
          (gtkfilesel-history-list-offset "history_list"))
;; Deprecated in gtk2
;  (fields "GtkText" 
;          (gtktext-text-area-offset "text_area")
;          (gtktext-hadj-offset      "hadj")
;          (gtktext-vadj-offset      "vadj"))
  (fields "GtkTextView"
          (layout-offset "layout")
          (buffer-offset "buffer")
          (text-window-offset "text_window")
          (left-window-offset "left_window")
          (right-window-offset "right_window")
          (top-window-offset "top_window")
          (bottom-window-offset "bottom_window")
          (hadjustment-offset "hadjustment")
          (vadjustment-offset "vadjustment")
          )
  (sizeof sizeof-gtktextiter "GtkTextIter")
  )

(define malloc-gtk-text-iter
  (let ((malloc (stdlib/malloc gtktextiter*-rt)) ; potential space leak!
        (size sizeof-gtktextiter))
    (lambda ()
      (malloc size))))

(define (gtk-text-view-hadjustment text-view)
  (void*-void*-ref text-view hadjustment-offset))
(define (gtk-text-view-vadjustment text-view)
  (void*-void*-ref text-view vadjustment-offset))

(define (gtk-dialog-vbox dialog)
  (void*-void*-ref dialog gtkdialog-vbox-offset))
(define (gtk-dialog-action-area dialog)
  (void*-void*-ref dialog gtkdialog-action-area-offset))

(define-gtk-foreign (gtk-file-selection-new string) gtkfileselection*)
(define-gtk-foreign (gtk-file-selection-set-filename gtkfileselection* string) void)
(define-gtk-foreign (gtk-file-selection-get-filename gtkfileselection*) string)
(define-gtk-foreign (gtk-file-selection-complete gtkfileselection* string) void)
(define-gtk-foreign (gtk-file-selection-show-fileop-buttons gtkfileselection*) void)
(define-gtk-foreign (gtk-file-selection-hide-fileop-buttons gtkfileselection*) void)
;; XXX add support for gtk_file_selection_get_selections
(define-gtk-foreign (gtk-file-selection-set-select-multiple gtkfileselection* bool) void)
(define-gtk-foreign (gtk-file-selection-get-select-multiple gtkfileselection*) bool)

(define (gtk-file-selection-ok-button filesel)
  (void*-void*-ref filesel gtkfilesel-ok-button-offset))
(define (gtk-file-selection-cancel-button filesel)
  (void*-void*-ref filesel gtkfilesel-cancel-button-offset))

;; BELOW ARE DEPRECATED ACCORDING TO GTK+ HEADER FILES...
(define GTK-TOOLBAR-CHILD-SPACE 0)
(define GTK-TOOLBAR-CHILD-BUTTON 1)
(define GTK-TOOLBAR-CHILD-TOGGLEBUTTON 2)
(define GTK-TOOLBAR-CHILD-RADIOBUTTON 3)
(define GTK-TOOLBAR-CHILD-WIDGET 4)
